/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1BitString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.Utils;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.BDS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algOID = algId.getAlgorithm();
        if (algOID.on(BCObjectIdentifiers.qTESLA)) {
            ASN1OctetString qTESLAPriv = ASN1OctetString.getInstance(keyInfo.parsePrivateKey());
            return new QTESLAPrivateKeyParameters(Utils.qTeslaLookupSecurityCategory(keyInfo.getPrivateKeyAlgorithm()), qTESLAPriv.getOctets());
        }
        if (algOID.equals(BCObjectIdentifiers.sphincs256)) {
            return new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters())));
        }
        if (algOID.equals(BCObjectIdentifiers.newHope)) {
            return new NHPrivateKeyParameters(PrivateKeyFactory.convert(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets()));
        }
        if (algOID.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            byte[] keyEnc = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            ASN1BitString pubKey = keyInfo.getPublicKeyData();
            if (Pack.bigEndianToInt(keyEnc, 0) == 1) {
                if (pubKey != null) {
                    byte[] pubEnc = pubKey.getOctets();
                    return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange(keyEnc, 4, keyEnc.length), Arrays.copyOfRange(pubEnc, 4, pubEnc.length));
                }
                return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange(keyEnc, 4, keyEnc.length));
            }
            if (pubKey != null) {
                byte[] pubEnc = pubKey.getOctets();
                return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(keyEnc, 4, keyEnc.length), pubEnc);
            }
            return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(keyEnc, 4, keyEnc.length));
        }
        if (algOID.equals(BCObjectIdentifiers.xmss)) {
            XMSSKeyParams keyParams = XMSSKeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters());
            ASN1ObjectIdentifier treeDigest = keyParams.getTreeDigest().getAlgorithm();
            XMSSPrivateKey xmssPrivateKey = XMSSPrivateKey.getInstance(keyInfo.parsePrivateKey());
            try {
                XMSSPrivateKeyParameters.Builder keyBuilder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(keyParams.getHeight(), Utils.getDigest(treeDigest))).withIndex(xmssPrivateKey.getIndex()).withSecretKeySeed(xmssPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xmssPrivateKey.getSecretKeyPRF()).withPublicSeed(xmssPrivateKey.getPublicSeed()).withRoot(xmssPrivateKey.getRoot());
                if (xmssPrivateKey.getVersion() != 0) {
                    keyBuilder.withMaxIndex(xmssPrivateKey.getMaxIndex());
                }
                if (xmssPrivateKey.getBdsState() != null) {
                    BDS bds = (BDS)XMSSUtil.deserialize(xmssPrivateKey.getBdsState(), BDS.class);
                    keyBuilder.withBDSState(bds.withWOTSDigest(treeDigest));
                }
                return keyBuilder.build();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("ClassNotFoundException processing BDS state: " + e.getMessage());
            }
        }
        if (algOID.equals(PQCObjectIdentifiers.xmss_mt)) {
            XMSSMTKeyParams keyParams = XMSSMTKeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters());
            ASN1ObjectIdentifier treeDigest = keyParams.getTreeDigest().getAlgorithm();
            try {
                XMSSMTPrivateKey xmssMtPrivateKey = XMSSMTPrivateKey.getInstance(keyInfo.parsePrivateKey());
                XMSSMTPrivateKeyParameters.Builder keyBuilder = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(keyParams.getHeight(), keyParams.getLayers(), Utils.getDigest(treeDigest))).withIndex(xmssMtPrivateKey.getIndex()).withSecretKeySeed(xmssMtPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xmssMtPrivateKey.getSecretKeyPRF()).withPublicSeed(xmssMtPrivateKey.getPublicSeed()).withRoot(xmssMtPrivateKey.getRoot());
                if (xmssMtPrivateKey.getVersion() != 0) {
                    keyBuilder.withMaxIndex(xmssMtPrivateKey.getMaxIndex());
                }
                if (xmssMtPrivateKey.getBdsState() != null) {
                    BDSStateMap bdsState = (BDSStateMap)XMSSUtil.deserialize(xmssMtPrivateKey.getBdsState(), BDSStateMap.class);
                    keyBuilder.withBDSState(bdsState.withWOTSDigest(treeDigest));
                }
                return keyBuilder.build();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("ClassNotFoundException processing BDS state: " + e.getMessage());
            }
        }
        if (algOID.equals(PQCObjectIdentifiers.mcElieceCca2)) {
            McElieceCCA2PrivateKey mKey = McElieceCCA2PrivateKey.getInstance(keyInfo.parsePrivateKey());
            return new McElieceCCA2PrivateKeyParameters(mKey.getN(), mKey.getK(), mKey.getField(), mKey.getGoppaPoly(), mKey.getP(), Utils.getDigestName(mKey.getDigest().getAlgorithm()));
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static short[] convert(byte[] octets) {
        short[] rv = new short[octets.length / 2];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = Pack.littleEndianToShort(octets, i * 2);
        }
        return rv;
    }
}

