/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.CipherSpiExt;

public abstract class AsymmetricHybridCipher
extends CipherSpiExt {
    protected AlgorithmParameterSpec paramSpec;

    protected final void setMode(String modeName) {
    }

    protected final void setPadding(String paddingName) {
    }

    public final byte[] getIV() {
        return null;
    }

    public final int getBlockSize() {
        return 0;
    }

    public final AlgorithmParameterSpec getParameters() {
        return this.paramSpec;
    }

    public final int getOutputSize(int inLen) {
        return this.opMode == 1 ? this.encryptOutputSize(inLen) : this.decryptOutputSize(inLen);
    }

    public final void initEncrypt(Key key) throws InvalidKeyException {
        try {
            this.initEncrypt(key, null, CryptoServicesRegistrar.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.initEncrypt(key, null, random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initEncrypt(key, params, CryptoServicesRegistrar.getSecureRandom());
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opMode = 1;
        this.initCipherEncrypt(key, params, random);
    }

    public final void initDecrypt(Key key) throws InvalidKeyException {
        try {
            this.initDecrypt(key, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opMode = 2;
        this.initCipherDecrypt(key, params);
    }

    public abstract byte[] update(byte[] var1, int var2, int var3);

    public final int update(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException {
        if (output.length < this.getOutputSize(inLen)) {
            throw new ShortBufferException("output");
        }
        byte[] out = this.update(input, inOff, inLen);
        System.arraycopy(out, 0, output, outOff, out.length);
        return out.length;
    }

    public abstract byte[] doFinal(byte[] var1, int var2, int var3) throws BadPaddingException;

    public final int doFinal(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException, BadPaddingException {
        if (output.length < this.getOutputSize(inLen)) {
            throw new ShortBufferException("Output buffer too short.");
        }
        byte[] out = this.doFinal(input, inOff, inLen);
        System.arraycopy(out, 0, output, outOff, out.length);
        return out.length;
    }

    protected abstract int encryptOutputSize(int var1);

    protected abstract int decryptOutputSize(int var1);

    protected abstract void initCipherEncrypt(Key var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void initCipherDecrypt(Key var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;
}

