/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCertificate;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCipher;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsDHConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsDHDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsECConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsECDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHMAC;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHash;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsNonceGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRP6Client;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRP6Server;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRPConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;

public interface TlsCrypto {
    public boolean hasAllRawSignatureAlgorithms();

    public boolean hasDHAgreement();

    public boolean hasECDHAgreement();

    public boolean hasEncryptionAlgorithm(int var1);

    public boolean hasCryptoHashAlgorithm(int var1);

    public boolean hasCryptoSignatureAlgorithm(int var1);

    public boolean hasMacAlgorithm(int var1);

    public boolean hasNamedGroup(int var1);

    public boolean hasRSAEncryption();

    public boolean hasSignatureAlgorithm(short var1);

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm var1);

    public boolean hasSignatureScheme(int var1);

    public boolean hasSRPAuthentication();

    public TlsSecret createSecret(byte[] var1);

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion var1);

    public SecureRandom getSecureRandom();

    public TlsCertificate createCertificate(byte[] var1) throws IOException;

    public TlsCipher createCipher(TlsCryptoParameters var1, int var2, int var3) throws IOException;

    public TlsDHDomain createDHDomain(TlsDHConfig var1);

    public TlsECDomain createECDomain(TlsECConfig var1);

    public TlsSecret adoptSecret(TlsSecret var1);

    public TlsHash createHash(int var1);

    public TlsHMAC createHMAC(int var1);

    public TlsHMAC createHMACForHash(int var1);

    public TlsNonceGenerator createNonceGenerator(byte[] var1);

    public TlsSRP6Client createSRP6Client(TlsSRPConfig var1);

    public TlsSRP6Server createSRP6Server(TlsSRPConfig var1, BigInteger var2);

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig var1);

    public TlsSecret hkdfInit(int var1);
}

