/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsAgreement;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;

public class BcTlsDH
implements TlsAgreement {
    protected final BcTlsDHDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected DHPublicKeyParameters peerPublicKey;

    public BcTlsDH(BcTlsDHDomain domain) {
        this.domain = domain;
    }

    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKeyParameters)this.localKeyPair.getPublic());
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateDHAgreement((DHPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

