/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import net.savignano.thirdparty.org.bouncycastle.tls.DigitallySigned;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureScheme;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsECDSA13Verifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private final int signatureScheme;

    public JcaTlsECDSA13Verifier(JcaTlsCrypto crypto, PublicKey publicKey, int signatureScheme) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        if (!SignatureScheme.isECDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
        this.signatureScheme = signatureScheme;
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        try {
            Signature signer = this.crypto.getHelper().createSignature("NoneWithECDSA");
            signer.initVerify(this.publicKey);
            signer.update(hash, 0, hash.length);
            return signer.verify(signature.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

