/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.PartialHashtree;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformationVerifier;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.tsp.TSPException;
import net.savignano.thirdparty.org.bouncycastle.tsp.TimeStampToken;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ArchiveTimeStampValidationException;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.BinaryTreeRootCalculator;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSData;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSException;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSUtil;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Store;

public class ERSArchiveTimeStamp {
    private final ArchiveTimeStamp archiveTimeStamp;
    private final DigestCalculator digCalc;
    private final TimeStampToken timeStampToken;
    private ERSRootNodeCalculator rootNodeCalculator = new BinaryTreeRootCalculator();

    public ERSArchiveTimeStamp(byte[] archiveTimeStamp, DigestCalculatorProvider digCalcProv) throws TSPException, ERSException {
        this(ArchiveTimeStamp.getInstance(archiveTimeStamp), digCalcProv);
    }

    public ERSArchiveTimeStamp(ArchiveTimeStamp archiveTimeStamp, DigestCalculatorProvider digCalcProv) throws TSPException, ERSException {
        try {
            this.archiveTimeStamp = archiveTimeStamp;
            this.timeStampToken = new TimeStampToken(archiveTimeStamp.getTimeStamp());
            this.digCalc = digCalcProv.get(archiveTimeStamp.getDigestAlgorithmIdentifier());
        }
        catch (IOException e) {
            throw new ERSException(e.getMessage(), e);
        }
        catch (OperatorCreationException e) {
            throw new ERSException(e.getMessage(), e);
        }
    }

    ERSArchiveTimeStamp(ArchiveTimeStamp archiveTimeStamp, DigestCalculator digCalc, ERSRootNodeCalculator rootNodeCalculator) throws TSPException, ERSException {
        try {
            this.archiveTimeStamp = archiveTimeStamp;
            this.timeStampToken = new TimeStampToken(archiveTimeStamp.getTimeStamp());
            this.digCalc = digCalc;
            this.rootNodeCalculator = rootNodeCalculator;
        }
        catch (IOException e) {
            throw new ERSException(e.getMessage(), e);
        }
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.archiveTimeStamp.getDigestAlgorithmIdentifier();
    }

    public void validatePresent(ERSData data, Date atDate) throws ERSException, OperatorCreationException {
        this.validatePresent(data.getHash(this.digCalc), atDate);
    }

    public void validatePresent(byte[] hash, Date atDate) throws ERSException, OperatorCreationException {
        if (this.timeStampToken.getTimeStampInfo().getGenTime().after(atDate)) {
            throw new ArchiveTimeStampValidationException("timestamp generation time is in the future");
        }
        this.checkContainsHashValue(hash, this.digCalc);
        PartialHashtree[] partialTree = this.archiveTimeStamp.getReducedHashTree();
        byte[] rootHash = partialTree != null ? this.rootNodeCalculator.computeRootHash(this.digCalc, this.archiveTimeStamp.getReducedHashTree()) : hash;
        this.checkTimeStampValid(this.timeStampToken, rootHash);
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public X509CertificateHolder getSigningCertificate() {
        Collection<X509CertificateHolder> certs;
        Store<X509CertificateHolder> certificateStore = this.timeStampToken.getCertificates();
        if (certificateStore != null && !(certs = certificateStore.getMatches(this.timeStampToken.getSID())).isEmpty()) {
            return certs.iterator().next();
        }
        return null;
    }

    public void validate(SignerInformationVerifier verifier) throws TSPException {
        this.timeStampToken.validate(verifier);
    }

    void checkContainsHashValue(byte[] hash, DigestCalculator digCalc) throws ArchiveTimeStampValidationException {
        PartialHashtree[] reducedHashTree = this.archiveTimeStamp.getReducedHashTree();
        if (reducedHashTree != null) {
            for (int i = 0; i != reducedHashTree.length; ++i) {
                PartialHashtree current = reducedHashTree[i];
                if (current.containsHash(hash)) {
                    return;
                }
                if (current.getValueCount() <= 1 || !Arrays.areEqual(hash, ERSUtil.calculateBranchHash(digCalc, current.getValues()))) continue;
                return;
            }
            throw new ArchiveTimeStampValidationException("object hash not found");
        }
        if (!Arrays.areEqual(hash, this.timeStampToken.getTimeStampInfo().getMessageImprintDigest())) {
            throw new ArchiveTimeStampValidationException("object hash not found in wrapped timestamp");
        }
    }

    void checkTimeStampValid(TimeStampToken timeStampToken, byte[] hash) throws ArchiveTimeStampValidationException {
        if (hash != null && !Arrays.areEqual(hash, timeStampToken.getTimeStampInfo().getMessageImprintDigest())) {
            throw new ArchiveTimeStampValidationException("timestamp hash does not match root");
        }
    }

    public Date getGenTime() {
        return this.timeStampToken.getTimeStampInfo().getGenTime();
    }

    public Date getExpiryTime() {
        X509CertificateHolder crtHolder = this.getSigningCertificate();
        if (crtHolder != null) {
            return crtHolder.getNotAfter();
        }
        return null;
    }

    public ArchiveTimeStamp toASN1Structure() {
        return this.archiveTimeStamp;
    }

    public byte[] getEncoded() throws IOException {
        return this.archiveTimeStamp.getEncoded();
    }
}

