/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common;

import java.util.Optional;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeySource;

public enum EProperty {
    GUI_KEY("gui.key", String.class, null),
    GUI_VERSION("gui.version", String.class, null),
    MAILER_VERSION("mailer.version", String.class, null),
    PUBLIC_KEYSERVER_PGP_LOCATION("pgp.keyserverLocation", String.class, null),
    PUBLIC_KEYSTORE_PGP_LOCATION("pgp.keystoreLocation", String.class, null),
    PUBLIC_KEYSTORE_SMIME_LOCATION("smime.keystoreLocation", String.class, null),
    PUBLIC_KEYSTORE_SMIME_TYPE("smime.keystoreType", String.class, "PKCS7"),
    PRIVATE_SMIME_KEYSTORE_LOCATION("smime.private.keystoreLocation", String.class, null),
    PRIVATE_SMIME_KEY_PASSWORD("smime.private.keyPassword", char[].class, null),
    PRIVATE_PGP_KEYSTORE_LOCATION("pgp.private.keystoreLocation", String.class, null),
    PRIVATE_PGP_KEY_PASSWORD("pgp.private.keyPassword", char[].class, null),
    USER_DIRECTORY_LDAP_QUERY_SMIME("ldap.smime.query", Boolean.class, false),
    PUBLIC_LDAP_HOST_SMIME("ldap.smime.public.host", String.class, null),
    PUBLIC_LDAP_PORT_SMIME("ldap.smime.public.port", Long.class, 389L),
    PUBLIC_LDAP_SSL_SMIME("ldap.smime.public.ssl", Boolean.class, false),
    PUBLIC_LDAP_DN_SMIME("ldap.smime.public.dn", String.class, null),
    PUBLIC_LDAP_FILTER_SMIME("ldap.smime.public.fitler", String.class, null),
    PUBLIC_LDAP_LOGIN_USER_SMIME("ldap.smime.public.login.user", String.class, null),
    PUBLIC_LDAP_LOGIN_PASSWORD_SMIME("ldap.smime.public.login.password", char[].class, null),
    PUBLIC_LDAP_URL_PGP("ldap.pgp.public.url", String.class, null),
    PUBLIC_LDAP_SSL_PGP("ldap.pgp.public.ssl", Boolean.class, false),
    PUBLIC_LDAP_DN_PGP("ldap.pgp.public.dn", String.class, null),
    PUBLIC_LDAP_FILTER_PGP("ldap.pgp.public.fitler", String.class, null),
    PUBLIC_LDAP_LOGIN_USER_PGP("ldap.pgp.public.login.user", String.class, null),
    PUBLIC_LDAP_LOGIN_PASSWORD_PGP("ldap.pgp.public.login.password", char[].class, null),
    EXPIRE_KEYS_PUBLIC_TIMESTAMP("mailer.expireKeys.timeStamp", Long.class, null),
    EXPIRE_KEYS_PRIVATE_TIMESTAMP("mailer.expireKeys.private.timeStamp", Long.class, null),
    ENCRYPTION_TYPE_PRIORITY("mailer.encryptionTypePriority", EEncryptionTypePriority.class, (Object)((Object)EEncryptionTypePriority.SMIME_PREFERED)),
    ENCRYPTION_FAILURE_BEHAVIOR("mailer.encryptionFailureBehavior", EEncryptionFailureBehavior.class, (Object)((Object)EEncryptionFailureBehavior.ALLOW)),
    REPORT_MESSAGE_SHOW_LINK("mailer.reportMessage.showLink", Boolean.class, false),
    ALLOW_PASSWORD_RESET_MAIL("mailer.passwordResetMail.unencrypted", Boolean.class, false),
    FREEZE_SNOTIFY("mailer.freeze", Boolean.class, false),
    DISABLE_SNOTIFY("mailer.disable", Boolean.class, false),
    DEV_MODE("dev.mode", Boolean.class, false),
    LITE_MODE("lite.mode", Boolean.class, false),
    ALLOW_PGP_PUBLIC_KEY_OVERWRITE("pgp.key.allowUserOverwrite", Boolean.class, true),
    ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE("pgp.key.allowJsdUserOverwrite", Boolean.class, false),
    ALLOW_SMIME_CERTIFICATE_OVERWRITE("smime.cert.allowUserOverwrite", Boolean.class, true),
    ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE("smime.cert.allowJsdUserOverwrite", Boolean.class, false),
    SUBJECT_PROTECTION("mailer.encryption.subjectProtection", Boolean.class, false),
    SUBJECT_PROTECTION_KEEP_ID("mailer.encryption.subjectProtectionKeepId", Boolean.class, false),
    DECORATE_RECEIVED_MAILS("mailer.received.decorate", Boolean.class, false),
    SIGNING_ENABLED("mailer.sign.enabled", Boolean.class, true),
    REMOVE_SIGNATURES("mailer.signature.remove", Boolean.class, true),
    EXTRACT_PUBLIC_KEY_FROM_SIGNATURES("pgp.signature.extractPublicKey", Boolean.class, false),
    EXTRACT_CERTIFICATE_FROM_SIGNATURES("smime.signature.extractPublicKey", Boolean.class, false),
    WHITELIST_USER_GROUP("mailer.whitelist.usergroup", String.class, null),
    ENABLE_PROJECT_SPECIFIC_ENCRYPTION("project.enableSpecificEncryption", Boolean.class, false),
    DEFAULT_PROJECT_ENCRYPTION_STATE("project.defaultEncryptionState", Boolean.class, true),
    AMBIGUOUS_PROJECT_ENCRYPTION_STATE("project.ambiguousEncryptionState", Boolean.class, true),
    NO_PROJECT_ENCRYPTION_STATE("project.noEncryptionState", Boolean.class, true),
    EMAIL_SMIME_CERT("email.smime.cert", byte[].class, null),
    EMAIL_SMIME_TIME_STAMP("email.smime.timeStamp", Long.class, null),
    EMAIL_SMIME_KEY_SOURCE("email.smime.keySource", EKeySource.class, (Object)((Object)EKeySource.UNKNOWN)),
    EMAIL_PGP_KEY("email.pgp.key", byte[].class, null),
    EMAIL_PGP_KEY_ID("email.pgp.key.id", Long.class, null),
    EMAIL_PGP_TIME_STAMP("email.pgp.timeStamp", Long.class, null),
    EMAIL_PGP_KEY_SOURCE("email.pgp.keySource", EKeySource.class, (Object)((Object)EKeySource.UNKNOWN)),
    PROJECT_ENABLE_ENCRYPTION("project.enableEncryption", Boolean.class, false),
    TWEAK_OVERVIEW("tweak.overview", String.class, null),
    TWEAK_DO_NOT_ENCODE_PGP_SEARCH_PARAMETER("tweak.doNotEncodePgpSearchParam", Boolean.class, false),
    TWEAK_URL_CONNECTION_TIMEOUT("tweak.urlConnectionTimeoutDuringMailing", Long.class, 20000L),
    TWEAK_DRY_RUN_MAILER("tweak.dryRunMailer", Boolean.class, false),
    TWEAK_EXPECT_P7B_IN_LDAP("tweak.expectP7bInLdap", Boolean.class, false),
    TWEAK_SMIME_OPAQUE_SIGN("tweak.smimeOpaqueSign", Boolean.class, false),
    TWEAK_SMIME_ADDITIONAL_SIGN("tweak.smimeAdditionalSign", Boolean.class, false),
    TWEAK_SMIME_IGNORE_CERT_PATH_VALIDATION("tweak.smimeIgnoreCertPathValidation", Boolean.class, false),
    TWEAK_PGP_ADDITIONAL_SIGN("tweak.pgpAdditionalSign", Boolean.class, false),
    TWEAK_PGP_INLINE_SUPPORT("tweak.pgpInlineSupport", Boolean.class, false),
    TWEAK_SKIP_ENCRYPTION_REGEX("tweak.skipEncryptionRegex", String.class, null),
    TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT("tweak.reportAdditionalText", String.class, null),
    TWEAK_REPORT_MESSAGE_REPLACE_TEXT("tweak.reportReplaceText", String.class, null),
    TWEAK_PGP_SYMMETRIY_KEY_ALGORITHM("tweak.pgpSymmetricCipher", Long.class, null),
    TWEAK_RECEIVED_MAILS_EXTENDED_DECORATION("tweak.incomingMailExtendedDecoration", Boolean.class, false),
    TWEAK_CERTIFICATION_REVOCATION_ENABLED("tweak.smimeCertificateCrlCheck", Boolean.class, false),
    TWEAK_SUBJECT_PROTECTION_REPLACEMENT("tweak.subjectProtectionReplacement", String.class, null),
    TWEAK_SUBJECT_PROTECTION_METHOD("tweak.subjectProtectionMethod", String.class, "protected-headers-v1");

    private static final String PREFIX = "net.savignano.snotify.";
    private final String key;
    private final Class<?> type;
    private final Object defValue;

    public static final Optional<EProperty> getProperty(String key) {
        if (key == null) {
            return Optional.empty();
        }
        String k = key.startsWith(PREFIX) ? key : PREFIX + key;
        for (EProperty prop : EProperty.values()) {
            if (!prop.getKey().equals(k)) continue;
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    private EProperty(String key, Class<?> type, Object defValue) {
        this.key = PREFIX + key;
        this.type = type;
        this.defValue = defValue;
        if (key == null) {
            throw new IllegalStateException("Key must not be null.");
        }
        if (type == null) {
            throw new IllegalStateException("Type must not be null.");
        }
        if (defValue != null && !type.isAssignableFrom(defValue.getClass())) {
            throw new IllegalStateException("\"" + defValue + "\" (" + defValue.getClass().getCanonicalName() + ") is not assignable as default value. Value is expected to be of class: " + type.getCanonicalName());
        }
        if (defValue == null && (type.isEnum() || type == Boolean.class)) {
            throw new IllegalStateException("Default value must not be null for this class type.");
        }
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defValue;
    }
}

