/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.ALdapLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpGlobalDirectoryLoader
extends ALdapLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpGlobalDirectoryLoader.class);
    public static final int INFO_SERVER_INFO = 301;
    public static final int INFO_SERVER_INFO_NOT_AVAILABLE = 302;
    private static final String PGP_KEY_SERVER_DN = "cn=PGPServerInfo";
    private static final String PGP_KEY_DN_FIELD = "pgpBaseKeySpaceDN";
    private static final String PGP_SOFTWARE_FIELD = "pgpSoftware";
    private static final String PGP_USER_ID_FIELD = "pgpUserId";
    private static final String PGP_KEY_FIELD = "pgpKey";
    private static final String PGP_KEY_LEGACY_FIELD = "pgpKeyV2";
    private static final String PGP_DISABLED_FIELD = "pgpDisabled";
    private static final String PGP_REVOKED_FIELD = "pgpRevoked";
    private String email;

    public PgpGlobalDirectoryLoader(LdapConnector connector) {
        super(connector);
        this.setKeySource(EKeySource.KEYSERVER);
    }

    public PgpGlobalDirectoryLoader(LdapConnector connector, String email) {
        super(connector);
        this.setEmail(email);
        this.setKeySource(EKeySource.KEYSERVER);
    }

    @Override
    protected SnotifyPgpPublicKey loadLdapKey() throws Exception {
        List<Attribute> attributes = this.getKeyAttributes();
        SnotifyPgpPublicKey key = this.getKey(attributes);
        log.info("Key for <{}> in LDAP: {}", (Object)this.getEmail(), (Object)key);
        return key;
    }

    private List<Attribute> getKeyAttributes() throws NamingException {
        DirContext context = this.getConnector().getContext();
        String pgpKeyDn = this.getPgpKeyDn(context);
        String filter = "(&(pgpUserId=*<" + this.getEmail() + ">)(" + PGP_DISABLED_FIELD + "=0)(" + PGP_REVOKED_FIELD + "=0))";
        List<Attributes> attributes = this.getAttributes(context, pgpKeyDn, filter, new String[]{PGP_KEY_FIELD, PGP_KEY_LEGACY_FIELD});
        ArrayList<Attribute> keyAttributes = new ArrayList<Attribute>();
        for (Attributes attrs : attributes) {
            NamingEnumeration<? extends Attribute> attrsEnum = attrs.getAll();
            while (attrsEnum.hasMore()) {
                keyAttributes.add(attrsEnum.next());
            }
        }
        return keyAttributes;
    }

    private String getPgpKeyDn(DirContext context) throws NamingException {
        List<String> baseDns = this.getBaseDns(context);
        List<String> keyServerInfoDns = this.getKeyServerInfoDns(baseDns);
        log.debug("Looking up PGP server info in LDAP.");
        for (String keyServerInfoDn : keyServerInfoDns) {
            Attributes attrs;
            log.debug("Looking up PGP server info at: {}", (Object)keyServerInfoDn);
            try {
                attrs = context.getAttributes(keyServerInfoDn, new String[]{PGP_KEY_DN_FIELD, PGP_SOFTWARE_FIELD});
            }
            catch (NameNotFoundException e) {
                log.debug("Pgp server info not found at: " + keyServerInfoDn, (Throwable)e);
                continue;
            }
            log.debug("PGP server info found at: {}", (Object)keyServerInfoDn);
            String serverInfo = (String)attrs.get(PGP_SOFTWARE_FIELD).get();
            log.info("PGP key server software: {}", (Object)serverInfo);
            this.getInfoDataManager().send(new InfoData(301, serverInfo));
            String pgpKeyDn = (String)attrs.get(PGP_KEY_DN_FIELD).get();
            log.debug("DN to search PGP keys in: {}", (Object)pgpKeyDn);
            return pgpKeyDn;
        }
        this.getInfoDataManager().send(new InfoData(302, new Object[0]));
        throw new NamingException("No PGP Server Info found. LDAP does probably not support PGP keys.");
    }

    private List<String> getBaseDns(DirContext context) throws NamingException {
        log.debug("Looking up naming contexts in LDAP.");
        Attributes attrs = context.getAttributes("", new String[]{"namingContexts"});
        Attribute attr = attrs.get("namingContexts");
        ArrayList<String> baseDns = new ArrayList<String>(attr.size());
        for (int i = 0; i < attr.size(); ++i) {
            String baseDn = (String)attr.get(i);
            log.trace("Base DN: {}", (Object)baseDn);
            baseDns.add(baseDn);
        }
        return baseDns;
    }

    private List<String> getKeyServerInfoDns(List<String> baseDns) {
        if (baseDns.contains(PGP_KEY_SERVER_DN)) {
            return Collections.singletonList(PGP_KEY_SERVER_DN);
        }
        ArrayList<String> keyServerInfoDns = new ArrayList<String>(baseDns.size());
        for (String baseDn : baseDns) {
            keyServerInfoDns.add("cn=PGPServerInfo," + baseDn);
        }
        return keyServerInfoDns;
    }

    private SnotifyPgpPublicKey getKey(List<Attribute> attributes) {
        SnotifyPgpPublicKey bestKey = null;
        for (Attribute attribute : attributes) {
            SnotifyPgpPublicKey key = this.getKey(attribute);
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                bestKey = key;
                break;
            }
            if (key.compareTo(bestKey) >= 0) continue;
            bestKey = key;
        }
        if (bestKey == null) {
            bestKey = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return bestKey;
    }

    private SnotifyPgpPublicKey getKey(Attribute attribute) {
        String keyString;
        try {
            keyString = (String)attribute.get();
        }
        catch (NamingException e) {
            log.error("Could not read PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        try {
            PGPPublicKeyRing keyRing = PgpUtil.loadPublicKey(new ByteArrayInputStream(keyString.getBytes(Constants.UTF8_CHARSET)));
            SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(keyRing, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (IOException e) {
            log.error("Could not load PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
        this.setUserFilter(email == null ? null : "(&(pgpUserId=*<" + email + ">)(" + PGP_DISABLED_FIELD + "=0)(" + PGP_REVOKED_FIELD + "=0))");
    }
}

