/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpSignKeyStoreLoader
extends AKeyLoader<SnotifyPgpSignKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpSignKeyStoreLoader.class);
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final PGPSecretKeyRingCollection keyRings;
    private final String email;
    private final char[] password;

    public PgpSignKeyStoreLoader(PGPSecretKeyRingCollection keyStore, char[] password, String email) {
        this.keyRings = keyStore;
        this.password = password;
        this.email = email;
    }

    @Override
    protected SnotifyPgpSignKey loadInternalKey() throws Exception {
        if (this.keyRings == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (this.email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        log.info("Looking up PGP private key for email <{}> in key rings.", (Object)this.getEmail());
        PGPSecretKeyRing keyRing = PgpUtil.getKeysForEmail(this.getKeyRings(), this.getEmail());
        if (keyRing != null) {
            log.info("Found valid PGP private key ring for email <{}> in key store.", (Object)this.getEmail());
            log.trace("Found PGP private key ring: {}", (Object)keyRing);
            this.getInfoDataManager().send(new InfoData(202, this.getEmail()));
            SnotifyPgpSignKey key = new SnotifyPgpSignKey(keyRing, this.password, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        log.info("Found no PGP private key for email <{}> in key store.", (Object)this.getEmail());
        this.getInfoDataManager().send(new InfoData(203, this.getEmail()));
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpSignKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpSignKey(validity, this.getKeySource());
    }

    public PGPSecretKeyRingCollection getKeyRings() {
        return this.keyRings;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "PgpSignKeyStoreLoader [keyRings=" + this.keyRings + ", password=*****, email=" + this.email + "]";
    }
}

