/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.sign;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.secret.ISnotifySecretKey;
import net.savignano.snotify.atlassian.mailer.ISessionProvider;
import net.savignano.snotify.atlassian.mailer.sign.IMailSigner;

public abstract class AMailSigner<T extends ISnotifySecretKey<?>>
implements IMailSigner<T>,
ISessionProvider {
    private final Session session;
    private final T privateKey;

    public AMailSigner(Session session, T privateKey) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Private key must not be null.");
        }
        this.session = session;
        this.privateKey = privateKey;
    }

    @Override
    public void signMessage(MimeMessage msg) throws IOException, MessagingException {
        if (msg == null) {
            return;
        }
        if (this.getPrivateKey().getKeyValidity() != EKeyValidity.VALID) {
            throw new MessagingException("Cannot sign message because of key having validity: " + (Object)((Object)this.getPrivateKey().getKeyValidity()));
        }
        this.sign(msg);
    }

    protected abstract void sign(MimeMessage var1) throws IOException, MessagingException;

    @Override
    public T getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Session getSession() {
        return this.session;
    }
}

