/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.validate;

import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.enums.EValidationType;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.mailer.validate.AMailValidator;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformationVerifier;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.i18n.ErrorBundle;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.validator.SignedMailValidator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import net.savignano.thirdparty.org.bouncycastle.x509.PKIXCertPathReviewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailValidator
extends AMailValidator<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailValidator.class);
    private final PKIXParameters pkixParams;

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME signed. Encountered message class: {}", message.getClass());
            return false;
        }
        MimePart part = (MimePart)message;
        return SmimeMailValidator.isMessageTransparentSigned(part) || SmimeMailValidator.isMessageOpaqueSigned(part);
    }

    public static final boolean isMessageOpaqueSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME signed. Encountered message class: {}", message.getClass());
            return false;
        }
        return SmimeMailValidator.isMessageOpaqueSigned((MimePart)message);
    }

    public static final boolean isMessageTransparentSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME signed. Encountered message class: {}", message.getClass());
            return false;
        }
        return SmimeMailValidator.isMessageTransparentSigned((MimePart)message);
    }

    private static final boolean isMessageOpaqueSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) {
                String smimeType = type.getParameter("smime-type");
                if (smimeType != null) {
                    return "signed-data".equalsIgnoreCase(smimeType);
                }
                return SmimeMailValidator.checkAsn1Type(part);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SmimeMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static final boolean checkAsn1Type(MimePart part) throws IOException, MessagingException {
        ASN1Primitive asn1;
        try (ASN1InputStream is = new ASN1InputStream(part.getInputStream());){
            asn1 = is.readObject();
        }
        ContentInfo info = ContentInfo.getInstance(asn1);
        return info != null && "1.2.840.113549.1.7.2".equals(info.getContentType().toString());
    }

    private static final boolean isMessageTransparentSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && (protocol.equals("application/pkcs7-signature") || protocol.equals("application/x-pkcs7-signature"));
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public SmimeMailValidator(PKIXParameters pkixParams) {
        this.pkixParams = pkixParams;
    }

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.CAN_VALIDATE, EValidationType.SIGNATURE, EValidationType.TRUST);
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, EKeySource.EMAIL);
    }

    @Override
    protected boolean isSigned(MimeMessage msg) {
        return SmimeMailValidator.isMessageSigned((Message)msg);
    }

    @Override
    protected boolean validate(MimeMessage msg, Set<EValidationType> validations, String email) throws Exception {
        ValidateVisitor visitor = new ValidateVisitor(this.pkixParams, validations);
        visitor.visit(msg);
        return visitor.isValid();
    }

    @Override
    protected SnotifySmimePublicKey extract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor(email);
        visitor.visit(msg);
        X509Certificate cert = visitor.getCertificate();
        if (cert == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        SnotifySmimePublicKey key = new SnotifySmimePublicKey(cert, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    private static final class ExtractVisitor
    extends Visitor {
        private final String email;
        private X509Certificate cert;

        public ExtractVisitor(String email) {
            this.email = email;
        }

        @Override
        public void handle(SMIMESigned signed) throws Exception {
            log.debug("Extracting public key for email: {}", (Object)this.email);
            Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
            KeyStore keyStore = SmimeUtil.convertToKeyStore(certificateHolders, "PKCS12", null);
            this.cert = SmimeUtil.getValidCertForEmail(keyStore, this.email, EKeyPurpose.ENCRYPTION);
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }
    }

    private static final class ValidateVisitor
    extends Visitor {
        private boolean valid = false;
        private final PKIXParameters pkixParams;
        private final Set<EValidationType> validations;

        public ValidateVisitor(PKIXParameters pkixParams, Set<EValidationType> validations) {
            this.pkixParams = pkixParams;
            this.validations = validations;
        }

        @Override
        public void visit(MimeMessage msg) throws Exception {
            log.debug("Validation types desired: {}", this.validations);
            if (this.pkixParams != null) {
                this.pkixParams.setDate(msg.getSentDate());
                this.handle(new SignedMailValidator(msg, this.pkixParams));
            } else {
                super.visit(msg);
            }
        }

        private void handle(SignedMailValidator validator) throws SignedMailValidatorException {
            if (this.validations.contains((Object)EValidationType.CAN_VALIDATE) && this.validations.size() == 1) {
                this.valid = true;
                return;
            }
            log.debug("Validating message.");
            Iterator<SignerInformation> it = validator.getSignerInformationStore().getSigners().iterator();
            this.valid = it.hasNext();
            while (this.valid && it.hasNext()) {
                SignerInformation signerInfo = it.next();
                String serialNumber = SmimeUtil.getSerialNumber(signerInfo.getSID().getSerialNumber());
                log.debug("Checking signature for certificate with serial number: {}", (Object)serialNumber);
                SignedMailValidator.ValidationResult result = validator.getValidationResult(signerInfo);
                if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                    this.valid = result.isVerifiedSignature();
                }
                if (this.valid && this.validations.contains((Object)EValidationType.TRUST)) {
                    if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                        this.valid = result.isValidSignature();
                    } else {
                        PKIXCertPathReviewer review = result.getCertPathReview();
                        boolean bl = this.valid = review != null && review.isValidCertPath();
                    }
                }
                if (!this.valid && log.isWarnEnabled()) {
                    this.logValidationResult(result, signerInfo);
                    continue;
                }
                log.debug("Signature check successful: {}", (Object)this.valid);
            }
            log.debug("Validation finished.");
        }

        private void logValidationResult(SignedMailValidator.ValidationResult result, SignerInformation signerInfo) {
            X509Certificate cert;
            PKIXCertPathReviewer review = result.getCertPathReview();
            List<? extends Certificate> certPathCerts = result.getCertPath().getCertificates();
            StringBuilder builder = new StringBuilder(500);
            builder.append("Validation for signer with certificate ID ");
            builder.append(SmimeUtil.getSerialNumber(signerInfo.getSID().getSerialNumber()));
            builder.append(" failed. Verified signature: ");
            builder.append(result.isVerifiedSignature());
            builder.append(". Cert path valid: ");
            builder.append(review.isValidCertPath());
            builder.append("\n");
            builder.append("  Validation errors: ");
            List errors = result.getErrors();
            this.logErrors(errors, builder);
            builder.append("  Cert path (length ");
            builder.append(certPathCerts.size());
            builder.append(")\n");
            if (certPathCerts.size() != 0) {
                for (int i = 0; i < certPathCerts.size(); ++i) {
                    cert = (X509Certificate)certPathCerts.get(i);
                    builder.append("    Cert ");
                    builder.append(i);
                    builder.append(": ");
                    builder.append(cert.getSubjectX500Principal());
                    builder.append("\" with ID ");
                    builder.append(SmimeUtil.getSerialNumber(cert));
                    builder.append("\n");
                }
                X509Certificate lastCert = (X509Certificate)certPathCerts.get(certPathCerts.size() - 1);
                builder.append("    Expected: ");
                builder.append(lastCert.getIssuerX500Principal());
                builder.append("\n");
            }
            builder.append("  Cert path validation errors:\n");
            for (int i = -1; i < certPathCerts.size(); ++i) {
                if (i == -1) {
                    builder.append("    Global errors: ");
                } else {
                    cert = (X509Certificate)certPathCerts.get(i);
                    builder.append("    Errors for cert \"");
                    builder.append(cert.getSubjectX500Principal());
                    builder.append("\" with ID ");
                    builder.append(SmimeUtil.getSerialNumber(cert));
                    builder.append(": ");
                }
                this.logErrors(review.getErrors(i), builder);
            }
            log.warn(builder.toString());
        }

        private void logErrors(List<ErrorBundle> errors, StringBuilder builder) {
            switch (errors.size()) {
                case 0: {
                    builder.append("No errors reported.\n");
                    break;
                }
                case 1: {
                    this.logErrorBundle(errors.get(0), builder);
                    builder.append("\n");
                    break;
                }
                default: {
                    builder.append("\n");
                    for (ErrorBundle error : errors) {
                        this.logErrorBundle(error, builder);
                        builder.append("\n");
                    }
                }
            }
        }

        private void logErrorBundle(ErrorBundle error, StringBuilder builder) {
            builder.append(error.getId());
            builder.append(": ");
            builder.append(error.getSummary(Locale.ENGLISH));
        }

        @Override
        public void handle(SMIMESigned signed) throws Exception {
            log.debug("Validating signed part.");
            Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
            Iterator<SignerInformation> signerInformations = signed.getSignerInfos().getSigners().iterator();
            this.valid = signerInformations.hasNext();
            while (this.valid && signerInformations.hasNext()) {
                SignerInformation signerInformation = signerInformations.next();
                log.debug("Checking signer ID for certificate with serial number: {}", (Object)signerInformation.getSID().getSerialNumber());
                X509CertificateHolder holder = certificateHolders.getMatches(signerInformation.getSID()).iterator().next();
                JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
                builder.setProvider(SecurityUtil.getProvider());
                SignerInformationVerifier verifier = builder.build(holder);
                this.valid = signerInformation.verify(verifier);
            }
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    private static abstract class Visitor
    extends BaseMessageVisitor {
        private Visitor() {
        }

        @Override
        public void visit(MimePart part) throws Exception {
            super.visit(part);
            ContentType type = new ContentType(part.getContentType());
            log.trace("MIME type: {}", (Object)type);
            if (SmimeMailValidator.isMessageTransparentSigned(part)) {
                log.debug("Found '{}' content.", (Object)type);
                MimeMultipart mp = (MimeMultipart)part.getContent();
                String encoding = part.getEncoding();
                SMIMESigned signed = encoding == null ? new SMIMESigned(mp) : new SMIMESigned(mp, encoding);
                this.handle(signed);
            } else if (SmimeMailValidator.isMessageOpaqueSigned(part)) {
                log.debug("Found '{}' content.", (Object)type);
                SMIMESigned signed = new SMIMESigned((Part)part);
                this.handle(signed);
            }
        }

        public abstract void handle(SMIMESigned var1) throws Exception;
    }
}

