/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.visitor.IMessageVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMessageVisitor
implements IMessageVisitor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String msgId;
    private boolean changed;

    public void visit(MimeMessage msg) throws Exception {
        this.reset();
        this.msgId = MessageUtil.getMessageId(msg);
        this.getLogger().trace("Visiting message: {}", (Object)this.msgId);
        this.visit((MimePart)msg);
        if (this.isChanged()) {
            msg.saveChanges();
            if (this.getLogger().isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)baos);
                this.getLogger().trace("Message changed. Final email:\n{}\n", (Object)baos.toString());
            }
        }
    }

    @Override
    public void visit(MimeMultipart multi) throws Exception {
        int count = multi.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart part = multi.getBodyPart(i);
            if (!(part instanceof MimeBodyPart)) continue;
            this.visit((MimePart)((MimeBodyPart)part));
        }
    }

    @Override
    public void visit(MimePart part) throws Exception {
        Object content = part.getContent();
        if (content instanceof MimeMultipart) {
            this.visit((MimeMultipart)content);
        }
    }

    protected void reset() {
        this.setChanged(false);
        this.msgId = null;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected String getMsgId() {
        return this.msgId;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

