/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;

public abstract class ContentTypeVisitor
extends BaseMessageVisitor {
    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        ContentType contentType = new ContentType(part.getContentType());
        this.getLogger().trace("Content Type: {}", (Object)contentType);
        if (this.isRelevant(contentType)) {
            this.handlePart(part);
        }
    }

    @Override
    public void visit(MimeMultipart mp) throws Exception {
        super.visit(mp);
        ContentType contentType = new ContentType(mp.getContentType());
        this.getLogger().trace("Content Type: {}", (Object)contentType);
        if (this.isRelevant(contentType)) {
            this.handleMultipart(mp);
        }
    }

    protected abstract boolean isRelevant(ContentType var1);

    protected void handleMultipart(MimeMultipart mp) throws Exception {
    }

    protected void handlePart(MimePart part) throws Exception {
    }
}

