/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;

public class DetectCryptographyVisitor
extends BaseMessageVisitor {
    private ECryptographyType type = ECryptographyType.NONE;
    private boolean checkInline;

    public DetectCryptographyVisitor() {
        this(false);
    }

    public DetectCryptographyVisitor(boolean checkInline) {
        this.setCheckInline(checkInline);
    }

    @Override
    public void visit(MimeMessage msg) throws Exception {
        super.visit(msg);
        this.getLogger().debug("Cryptography type detected for message with ID {}: {}", (Object)MessageUtil.getMessageId(msg), (Object)this.type);
    }

    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        ContentType contentType = new ContentType(part.getContentType());
        this.getLogger().trace("MIME type: {}", (Object)contentType);
        if (contentType.match("multipart/signed")) {
            this.handleSignedPart(contentType);
        } else if (contentType.match("application/pkcs7-mime") || contentType.match("application/x-pkcs7-mime")) {
            this.getLogger().debug("PKCS7 content found: {}", (Object)contentType);
            this.type = ECryptographyType.SMIME;
        } else if (contentType.match("application/pgp-encrypted")) {
            this.getLogger().debug("Encrypted content found: {}", (Object)contentType);
            this.type = ECryptographyType.PGP;
        } else if (this.isCheckInline()) {
            if (this.isInlineEncryptedSigned(part)) {
                this.getLogger().debug("Secured inline text found.");
                this.type = ECryptographyType.PGP;
            } else if (this.isInlineAttachment(part)) {
                this.getLogger().debug("Encrypted inline attachment found.");
                this.type = ECryptographyType.PGP;
            }
        }
    }

    private void handleSignedPart(ContentType contentType) {
        this.getLogger().debug("Signed content found: {}", (Object)contentType);
        String protocol = contentType.getParameter("protocol");
        if (protocol != null) {
            if (protocol.equalsIgnoreCase("application/pgp-signature")) {
                this.type = ECryptographyType.PGP;
            } else if (protocol.equalsIgnoreCase("application/pkcs7-signature") || protocol.equalsIgnoreCase("application/x-pkcs7-signature")) {
                this.type = ECryptographyType.SMIME;
            }
        }
        if (this.type == ECryptographyType.NONE) {
            this.getLogger().warn("Signed content found, but cannot determine what cryptographic method was used. Content type: {}", (Object)contentType);
        }
    }

    private boolean isInlineEncryptedSigned(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("text/plain")) {
            String content = (String)part.getContent();
            if (content.startsWith("-----BEGIN PGP MESSAGE-----")) {
                return true;
            }
            if (content.startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
                return true;
            }
        }
        return false;
    }

    private boolean isInlineAttachment(MimePart part) throws MessagingException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            ContentDisposition contentDisposition = new ContentDisposition(part.getHeader("Content-Disposition", null));
            String filename = contentDisposition.getParameter("filename");
            return filename != null && filename.endsWith(".pgp");
        }
        return false;
    }

    public ECryptographyType getType() {
        return this.type;
    }

    @Override
    public void reset() {
        this.type = ECryptographyType.NONE;
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }
}

