/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.visitor.ContentTypeVisitor;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;

public class SignatureRemover
extends ContentTypeVisitor {
    @Override
    protected boolean isRelevant(ContentType type) {
        return type.match("multipart/signed") || type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime");
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        this.getLogger().debug("Found '{}' content.", (Object)part.getContentType());
        if (part.isMimeType("multipart/signed")) {
            this.getLogger().info("Removing signature from message {}.", (Object)this.getMsgId());
            Multipart mp = (Multipart)part.getContent();
            BodyPart contentPart = mp.getBodyPart(0);
            this.removeSignature((MimeBodyPart)contentPart, part);
        } else if (this.isOpaqueSignature(part)) {
            this.getLogger().info("Removing signature from message {}.", (Object)this.getMsgId());
            SMIMESigned smimeSigned = new SMIMESigned((Part)part);
            MimeBodyPart content = smimeSigned.getContent();
            this.removeSignature(content, part);
        }
    }

    private void removeSignature(MimeBodyPart contentPart, MimePart parentPart) throws MessagingException, IOException {
        parentPart.setDisposition(null);
        parentPart.removeHeader("Content-Transfer-Encoding");
        parentPart.setContent(contentPart.getContent(), contentPart.getContentType());
        MessageUtil.copyAllHeaders((Part)contentPart, (Part)parentPart);
        this.setChanged(true);
    }

    private boolean isOpaqueSignature(MimePart part) throws IOException, MessagingException {
        ContentType type = new ContentType(part.getContentType());
        String smimeType = type.getParameter("smime-type");
        if (smimeType != null) {
            return smimeType.equalsIgnoreCase("signed-data");
        }
        return this.checkAsn1Type(part);
    }

    private boolean checkAsn1Type(MimePart part) throws IOException, MessagingException {
        ASN1Primitive asn1;
        try (ASN1InputStream is = new ASN1InputStream(part.getInputStream());){
            asn1 = is.readObject();
        }
        ContentInfo info = ContentInfo.getInstance(asn1);
        return info != null && "1.2.840.113549.1.7.2".equals(info.getContentType().toString());
    }
}

