/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCPublicationInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.PKIPublicationInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.SinglePubInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class CMCPublicationInfoTest
extends SimpleTest {
    public void performTest() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        AlgorithmIdentifier testIA = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.1.2.3"), DERNull.INSTANCE);
        byte[][] hashes = new byte[5][64];
        for (int i = 0; i < hashes.length; ++i) {
            secureRandom.nextBytes(hashes[i]);
        }
        PKIPublicationInfo pinfo = new PKIPublicationInfo(new SinglePubInfo(SinglePubInfo.dontCare, null));
        CMCPublicationInfo cmcPublicationInfo = new CMCPublicationInfo(testIA, hashes, pinfo);
        byte[] b = cmcPublicationInfo.getEncoded();
        CMCPublicationInfo resCmcPublicationInfo = CMCPublicationInfo.getInstance(b);
        this.isEquals(resCmcPublicationInfo, cmcPublicationInfo);
        try {
            CMCPublicationInfo.getInstance(new DERSequence(new ASN1Encodable[]{testIA}));
            this.fail("Expecting exception.");
        }
        catch (Exception t) {
            this.isEquals("Wrong exception: " + t.getMessage(), t.getClass(), IllegalArgumentException.class);
        }
    }

    public String getName() {
        return "CMCPublicationInfo";
    }

    public static void main(String[] args) {
        CMCPublicationInfoTest.runTest(new CMCPublicationInfoTest());
    }
}

