/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERUTF8String;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartID;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartReference;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.ControlsProcessed;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class ControlsProcessedTest
extends SimpleTest {
    public static void main(String[] args) {
        ControlsProcessedTest.runTest(new ControlsProcessedTest());
    }

    public String getName() {
        return "ControlsProcessedTest";
    }

    public void performTest() throws Exception {
        ControlsProcessed cp = new ControlsProcessed(new BodyPartReference[]{new BodyPartReference(new BodyPartID(12L)), new BodyPartReference(new BodyPartID(14L))});
        byte[] b = cp.getEncoded();
        ControlsProcessed cpResult = ControlsProcessed.getInstance(b);
        this.isTrue(cpResult.getBodyList().length == cp.getBodyList().length);
        this.isEquals(cpResult.getBodyList()[0], cp.getBodyList()[0]);
        this.isEquals(cpResult.getBodyList()[1], cp.getBodyList()[1]);
        try {
            ControlsProcessed.getInstance(new DERSequence(new ASN1Encodable[]{new ASN1Integer(12L), new DERUTF8String("Monkeys")}));
            this.fail("Must accept only sequence length of 1");
        }
        catch (Throwable t) {
            this.isEquals(t.getClass(), IllegalArgumentException.class);
        }
    }
}

