/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.SignerInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformation;

public class CMSPatchKit {
    public static SignerInformation createNonDERSignerInfo(SignerInformation original) {
        return new DLSignerInformation(original);
    }

    public static SignerInformation createWithSignatureAlgorithm(SignerInformation original, AlgorithmIdentifier signatureAlgorithm) {
        return new ModEncAlgSignerInformation(original, signatureAlgorithm);
    }

    private static class ModEncAlgSignerInformation
    extends SignerInformation {
        protected ModEncAlgSignerInformation(SignerInformation baseInfo, AlgorithmIdentifier signatureAlgorithm) {
            super(baseInfo, ModEncAlgSignerInformation.editEncAlg(baseInfo.info, signatureAlgorithm));
        }

        private static SignerInfo editEncAlg(SignerInfo info, AlgorithmIdentifier signatureAlgorithm) {
            return new SignerInfo(info.getSID(), info.getDigestAlgorithm(), info.getAuthenticatedAttributes(), signatureAlgorithm, info.getEncryptedDigest(), info.getUnauthenticatedAttributes());
        }
    }

    private static class DLSignerInformation
    extends SignerInformation {
        protected DLSignerInformation(SignerInformation baseInfo) {
            super(baseInfo);
        }

        public byte[] getEncodedSignedAttributes() throws IOException {
            return this.signedAttributeSet.getEncoded("DL");
        }
    }
}

