/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import net.savignano.thirdparty.org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Properties;

public class BCEdDSAPrivateKey
implements EdDSAPrivateKey {
    static final long serialVersionUID = 1L;
    transient AsymmetricKeyParameter eddsaPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    BCEdDSAPrivateKey(AsymmetricKeyParameter privKey) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.eddsaPrivateKey = privKey;
    }

    BCEdDSAPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.hasPublicKey = keyInfo.hasPublicKey();
        this.attributes = keyInfo.getAttributes() != null ? keyInfo.getAttributes().getEncoded() : null;
        this.populateFromPrivateKeyInfo(keyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo keyInfo) throws IOException {
        byte[] encoding = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
        this.eddsaPrivateKey = EdECObjectIdentifiers.id_Ed448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new Ed448PrivateKeyParameters(encoding) : new Ed25519PrivateKeyParameters(encoding);
    }

    public String getAlgorithm() {
        return this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters ? "Ed448" : "Ed25519";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            ASN1Set attrSet = ASN1Set.getInstance(this.attributes);
            PrivateKeyInfo privInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.eddsaPrivateKey, attrSet);
            if (this.hasPublicKey && !Properties.isOverrideSet("net.savignano.thirdparty.org.bouncycastle.pkcs8.v1_info_only")) {
                return privInfo.getEncoded();
            }
            return new PrivateKeyInfo(privInfo.getPrivateKeyAlgorithm(), privInfo.parsePrivateKey(), attrSet).getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public EdDSAPublicKey getPublicKey() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return new BCEdDSAPublicKey(((Ed448PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
        }
        return new BCEdDSAPublicKey(((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
    }

    AsymmetricKeyParameter engineGetKeyParameters() {
        return this.eddsaPrivateKey;
    }

    public String toString() {
        AsymmetricKeyParameter pubKey = this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters ? ((Ed448PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey() : ((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivateKey)) {
            return false;
        }
        PrivateKey other = (PrivateKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

