/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SignedData;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Uint8;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class CounterSignature
extends ASN1Object {
    private final Uint8 protocolVersion;
    private final SignedData signedData;

    public CounterSignature(Uint8 protocolVersion, SignedData signedData) {
        this.protocolVersion = protocolVersion;
        this.signedData = signedData;
    }

    public CounterSignature getInstance(Object src) {
        if (src instanceof CounterSignature) {
            return (CounterSignature)src;
        }
        Iterator<ASN1Encodable> items = ASN1Sequence.getInstance(src).iterator();
        return new CounterSignature(Uint8.getInstance(items.next()), SignedData.getInstance(items.next()));
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.protocolVersion, this.signedData);
    }

    public Uint8 getProtocolVersion() {
        return this.protocolVersion;
    }

    public SignedData getSignedData() {
        return this.signedData;
    }
}

