/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Null;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccCurvePoint;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public class EccP384CurvePoint
extends EccCurvePoint {
    public static final int xOnly = 0;
    public static final int fill = 1;
    public static final int compressedY0 = 2;
    public static final int compressedY1 = 3;
    public static final int uncompressedP384 = 4;
    private final int choice;
    private final ASN1Encodable value;

    public EccP384CurvePoint(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.value = value;
    }

    public static EccP384CurvePoint getInstance(Object object) {
        ASN1Primitive value;
        if (object instanceof EccP384CurvePoint) {
            return (EccP384CurvePoint)object;
        }
        ASN1TaggedObject ato = ASN1TaggedObject.getInstance(object);
        switch (ato.getTagNo()) {
            case 1: {
                value = ASN1Null.getInstance(ato.getObject());
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                value = ASN1OctetString.getInstance(ato.getObject());
                break;
            }
            case 4: {
                value = ASN1Sequence.getInstance(ato.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag " + ato.getTagNo());
            }
        }
        return new Builder().setChoice(ato.getTagNo()).setValue(value).createEccP384CurvePoint();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public byte[] getEncodedPoint() {
        byte[] key;
        switch (this.choice) {
            case 2: {
                byte[] originalKey = DEROctetString.getInstance(this.value).getOctets();
                key = new byte[originalKey.length + 1];
                key[0] = 2;
                System.arraycopy(originalKey, 0, key, 1, originalKey.length);
                break;
            }
            case 3: {
                byte[] originalKey = DEROctetString.getInstance(this.value).getOctets();
                key = new byte[originalKey.length + 1];
                key[0] = 3;
                System.arraycopy(originalKey, 0, key, 1, originalKey.length);
                break;
            }
            case 4: {
                ASN1Sequence sequence = ASN1Sequence.getInstance(this.value);
                byte[] x = DEROctetString.getInstance(sequence.getObjectAt(0)).getOctets();
                byte[] y = DEROctetString.getInstance(sequence.getObjectAt(1)).getOctets();
                key = Arrays.concatenate(new byte[]{4}, x, y);
                break;
            }
            case 0: {
                throw new IllegalStateException("x Only not implemented");
            }
            default: {
                throw new IllegalStateException("unknown point choice");
            }
        }
        return key;
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        Builder setValue(ASN1Encodable value) {
            this.value = value;
            return this;
        }

        public EccP384CurvePoint createXOnly(BigInteger x) {
            this.choice = 0;
            this.value = new DEROctetString(BigIntegers.asUnsignedByteArray(x));
            return this.createEccP384CurvePoint();
        }

        public EccP384CurvePoint createFill() {
            this.choice = 1;
            this.value = DERNull.INSTANCE;
            return this.createEccP384CurvePoint();
        }

        public EccP384CurvePoint createCompressedY0(BigInteger y) {
            this.choice = 2;
            throw new IllegalStateException("not fully implemented.");
        }

        public EccP384CurvePoint createCompressedY1(BigInteger y) {
            this.choice = 3;
            throw new IllegalStateException("not fully implemented.");
        }

        public EccP384CurvePoint createUncompressedP384(BigInteger x, BigInteger y) {
            this.choice = 4;
            this.value = new DERSequence(new ASN1Encodable[]{new DEROctetString(BigIntegers.asUnsignedByteArray(48, x)), new DEROctetString(BigIntegers.asUnsignedByteArray(48, y))});
            return this.createEccP384CurvePoint();
        }

        private EccP384CurvePoint createEccP384CurvePoint() {
            return new EccP384CurvePoint(this.choice, this.value);
        }
    }
}

