/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CircularRegion;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PolygonalRegion;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfIdentifiedRegion;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfRectangularRegion;

public class GeographicRegion
extends ASN1Object
implements ASN1Choice {
    public static final int circularRegion = 0;
    public static final int rectangularRegion = 1;
    public static final int polygonalRegion = 2;
    public static final int identifiedRegion = 3;
    public static final int extension = 4;
    private int choice;
    private ASN1Encodable region;

    public GeographicRegion(int choice, ASN1Encodable region) {
        this.choice = choice;
        this.region = region;
    }

    public static GeographicRegion getInstance(Object o) {
        if (o instanceof GeographicRegion) {
            return (GeographicRegion)o;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(o);
        int choice = taggedObject.getTagNo();
        switch (choice) {
            case 0: {
                return new GeographicRegion(choice, CircularRegion.getInstance(taggedObject.getObject()));
            }
            case 1: {
                return new GeographicRegion(choice, SequenceOfRectangularRegion.getInstance(taggedObject.getObject()));
            }
            case 2: {
                return new GeographicRegion(choice, PolygonalRegion.getInstance(taggedObject.getObject()));
            }
            case 3: {
                return new GeographicRegion(choice, SequenceOfIdentifiedRegion.getInstance(taggedObject.getObject()));
            }
            case 4: {
                return new GeographicRegion(choice, DEROctetString.getInstance(taggedObject.getObject()));
            }
        }
        throw new IllegalStateException("unknown region choice " + choice);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getRegion() {
        return this.region;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.region);
    }
}

