/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;

public class NinetyDegreeInt
extends ASN1Integer {
    private static final BigInteger loweBound = new BigInteger("-900000000");
    private static final BigInteger upperBound = new BigInteger("900000000");
    private static final BigInteger unknown = new BigInteger("900000001");

    public NinetyDegreeInt(long value) {
        super(value);
        this.assertValue();
    }

    public NinetyDegreeInt(BigInteger value) {
        super(value);
        this.assertValue();
    }

    public NinetyDegreeInt(byte[] bytes) {
        super(bytes);
        this.assertValue();
    }

    public static NinetyDegreeInt getInstance(Object o) {
        if (o instanceof NinetyDegreeInt) {
            return (NinetyDegreeInt)o;
        }
        return new NinetyDegreeInt(ASN1Integer.getInstance(o).getValue());
    }

    public void assertValue() {
        BigInteger bi = this.getValue();
        if (bi.compareTo(loweBound) < 0) {
            throw new IllegalStateException("ninety degree int cannot be less than -900000000");
        }
        if (bi.equals(unknown)) {
            return;
        }
        if (bi.compareTo(upperBound) > 0) {
            throw new IllegalStateException("ninety degree int cannot be greater than 900000000");
        }
    }
}

