/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.RecipientInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceOfRecipientInfo
extends ASN1Object {
    private final List<RecipientInfo> recipientInfos;

    public SequenceOfRecipientInfo(List<RecipientInfo> recipientInfos) {
        this.recipientInfos = Collections.unmodifiableList(recipientInfos);
    }

    public static SequenceOfRecipientInfo getInstance(Object object) {
        if (object instanceof SequenceOfRecipientInfo) {
            return (SequenceOfRecipientInfo)object;
        }
        ASN1Sequence sequence = ASN1Sequence.getInstance(object);
        Enumeration enumeration = sequence.getObjects();
        ArrayList<RecipientInfo> infoArrayList = new ArrayList<RecipientInfo>();
        while (enumeration.hasMoreElements()) {
            infoArrayList.add(RecipientInfo.getInstance(enumeration.nextElement()));
        }
        return new Builder().setRecipientInfos(infoArrayList).createSequenceOfRecipientInfo();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        return new DERSequence(v);
    }

    public List<RecipientInfo> getRecipientInfos() {
        return this.recipientInfos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<RecipientInfo> recipientInfos;

        public Builder setRecipientInfos(List<RecipientInfo> recipientInfos) {
            this.recipientInfos = recipientInfos;
            return this;
        }

        public Builder addRecipients(RecipientInfo ... items) {
            if (this.recipientInfos == null) {
                this.recipientInfos = new ArrayList<RecipientInfo>();
            }
            this.recipientInfos.addAll(Arrays.asList(items));
            return this;
        }

        public SequenceOfRecipientInfo createSequenceOfRecipientInfo() {
            return new SequenceOfRecipientInfo(this.recipientInfos);
        }
    }
}

