/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HeaderInfo;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SignedDataPayload;

public class ToBeSignedData
extends ASN1Object {
    private final SignedDataPayload payload;
    private final HeaderInfo headerInfo;

    public ToBeSignedData(SignedDataPayload payload, HeaderInfo headerInfo) {
        this.payload = payload;
        this.headerInfo = headerInfo;
    }

    public static ToBeSignedData getInstance(Object o) {
        if (o instanceof ToBeSignedData) {
            return (ToBeSignedData)o;
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(o);
        return new Builder().setPayload(SignedDataPayload.getInstance(seq.getObjectAt(0))).setHeaderInfo(HeaderInfo.getInstance(seq.getObjectAt(1))).createToBeSignedData();
    }

    public SignedDataPayload getPayload() {
        return this.payload;
    }

    public HeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.payload, this.headerInfo});
    }

    public static class Builder {
        private SignedDataPayload payload;
        private HeaderInfo headerInfo;

        public Builder setPayload(SignedDataPayload payload) {
            this.payload = payload;
            return this;
        }

        public Builder setHeaderInfo(HeaderInfo headerInfo) {
            this.headerInfo = headerInfo;
            return this;
        }

        public ToBeSignedData createToBeSignedData() {
            return new ToBeSignedData(this.payload, this.headerInfo);
        }
    }
}

