/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.DSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.TrustPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserAttributePacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserIDPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16, 31};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List<PGPSignature> keySigs = new ArrayList<PGPSignature>();
    List ids = new ArrayList();
    List<TrustPacket> idTrusts = new ArrayList<TrustPacket>();
    List<List<PGPSignature>> idSigs = new ArrayList<List<PGPSignature>>();
    List<PGPSignature> subSigs = null;
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;

    private void init(KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        BCPGKey key = this.publicPk.getKey();
        this.fingerprint = fingerPrintCalculator.calculateFingerprint(this.publicPk);
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rK = (RSAPublicBCPGKey)key;
            this.keyID = rK.getModulus().longValue();
            this.keyStrength = rK.getModulus().bitLength();
        } else {
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (key instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)key).getModulus().bitLength();
            } else if (key instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ECPublicBCPGKey) {
                X9ECParameters ecParameters;
                ASN1ObjectIdentifier curveOID = ((ECPublicBCPGKey)key).getCurveOID();
                this.keyStrength = curveOID.equals(GNUObjectIdentifiers.Ed25519) || curveOID.equals(CryptlibObjectIdentifiers.curvey25519) ? 256 : ((ecParameters = ECNamedCurveTable.getByOID(curveOID)) != null ? ecParameters.getCurve().getFieldSize() : -1);
            }
        }
    }

    public PGPPublicKey(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList();
        this.idSigs = new ArrayList<List<PGPSignature>>();
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List sigs, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.subSigs = sigs;
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey key, TrustPacket trust, List subSigs) {
        this.publicPk = key.publicPk;
        this.trustPk = trust;
        this.subSigs = subSigs;
        this.fingerprint = key.fingerprint;
        this.keyID = key.keyID;
        this.keyStrength = key.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pubKey) {
        int i;
        this.publicPk = pubKey.publicPk;
        this.keySigs = new ArrayList<PGPSignature>(pubKey.keySigs);
        this.ids = new ArrayList(pubKey.ids);
        this.idTrusts = new ArrayList<TrustPacket>(pubKey.idTrusts);
        this.idSigs = new ArrayList<List<PGPSignature>>(pubKey.idSigs.size());
        for (i = 0; i != pubKey.idSigs.size(); ++i) {
            this.idSigs.add(new ArrayList((ArrayList)pubKey.idSigs.get(i)));
        }
        if (pubKey.subSigs != null) {
            this.subSigs = new ArrayList<PGPSignature>(pubKey.subSigs.size());
            for (i = 0; i != pubKey.subSigs.size(); ++i) {
                this.subSigs.add(pubKey.subSigs.get(i));
            }
        }
        this.fingerprint = pubKey.fingerprint;
        this.keyID = pubKey.keyID;
        this.keyStrength = pubKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List keySigs, List ids, List idTrusts, List idSigs, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.keySigs = keySigs;
        this.ids = ids;
        this.idTrusts = idTrusts;
        this.idSigs = idSigs;
        this.init(fingerPrintCalculator);
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            long delta = this.getValidSeconds() % 86400L;
            int days = (int)(this.getValidSeconds() / 86400L);
            if (delta > 0L && days == 0) {
                return 1;
            }
            return days;
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone(this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                for (int i = 0; i != MASTER_KEY_CERTIFICATION_TYPES.length; ++i) {
                    long seconds = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (seconds < 0L) continue;
                    return seconds;
                }
            } else {
                long seconds = this.getExpirationTimeFromSig(false, 24);
                if (seconds >= 0L) {
                    return seconds;
                }
                seconds = this.getExpirationTimeFromSig(false, 31);
                if (seconds >= 0L) {
                    return seconds;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean selfSigned, int signatureType) {
        Iterator<PGPSignature> signatures = this.getSignaturesOfType(signatureType);
        long expiryTime = -1L;
        long lastDate = -1L;
        while (signatures.hasNext()) {
            PGPSignatureSubpacketVector hashed;
            PGPSignature sig = signatures.next();
            if (selfSigned && sig.getKeyID() != this.getKeyID() || (hashed = sig.getHashedSubPackets()) == null || !hashed.hasSubpacket(9)) continue;
            long current = hashed.getKeyExpirationTime();
            if (sig.getKeyID() == this.getKeyID()) {
                if (sig.getCreationTime().getTime() <= lastDate) continue;
                lastDate = sig.getCreationTime().getTime();
                expiryTime = current;
                continue;
            }
            if (current != 0L && current <= expiryTime) continue;
            expiryTime = current;
        }
        return expiryTime;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] tmp = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public boolean isEncryptionKey() {
        int algorithm = this.publicPk.getAlgorithm();
        return algorithm == 1 || algorithm == 2 || algorithm == 16 || algorithm == 20 || algorithm == 21 || algorithm == 18;
    }

    public boolean isMasterKey() {
        return this.subSigs == null && (!this.isEncryptionKey() || this.publicPk.getAlgorithm() == 1);
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public Iterator<String> getUserIDs() {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            temp.add(((UserIDPacket)this.ids.get(i)).getID());
        }
        return temp.iterator();
    }

    public Iterator<byte[]> getRawUserIDs() {
        ArrayList<byte[]> temp = new ArrayList<byte[]>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            temp.add(((UserIDPacket)this.ids.get(i)).getRawID());
        }
        return temp.iterator();
    }

    public Iterator<PGPUserAttributeSubpacketVector> getUserAttributes() {
        ArrayList temp = new ArrayList();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof PGPUserAttributeSubpacketVector)) continue;
            temp.add(this.ids.get(i));
        }
        return temp.iterator();
    }

    public Iterator<PGPSignature> getSignaturesForID(String id) {
        return this.getSignaturesForID(new UserIDPacket(id));
    }

    public Iterator<PGPSignature> getSignaturesForID(byte[] rawID) {
        return this.getSignaturesForID(new UserIDPacket(rawID));
    }

    public Iterator<PGPSignature> getSignaturesForKeyID(long keyID) {
        ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = it.next();
            if (sig.getKeyID() != keyID) continue;
            sigs.add(sig);
        }
        return sigs.iterator();
    }

    private Iterator<PGPSignature> getSignaturesForID(UserIDPacket id) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        boolean userIdFound = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!id.equals(this.ids.get(i))) continue;
            userIdFound = true;
            signatures.addAll(this.idSigs.get(i));
        }
        return userIdFound ? signatures.iterator() : null;
    }

    public Iterator<PGPSignature> getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector userAttributes) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        boolean attributeFound = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!userAttributes.equals(this.ids.get(i))) continue;
            attributeFound = true;
            signatures.addAll(this.idSigs.get(i));
        }
        return attributeFound ? signatures.iterator() : null;
    }

    public Iterator<PGPSignature> getSignaturesOfType(int signatureType) {
        ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = it.next();
            if (sig.getSignatureType() != signatureType) continue;
            l.add(sig);
        }
        return l.iterator();
    }

    public Iterator<PGPSignature> getSignatures() {
        if (this.subSigs == null) {
            ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>();
            sigs.addAll(this.keySigs);
            for (int i = 0; i != this.idSigs.size(); ++i) {
                sigs.addAll((Collection)this.idSigs.get(i));
            }
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public Iterator<PGPSignature> getKeySignatures() {
        if (this.subSigs == null) {
            ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>();
            sigs.addAll(this.keySigs);
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicPk;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, false);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.publicPk);
        if (!forTransfer && this.trustPk != null) {
            out.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int i;
            for (i = 0; i != this.keySigs.size(); ++i) {
                this.keySigs.get(i).encode(out);
            }
            for (i = 0; i != this.ids.size(); ++i) {
                if (this.ids.get(i) instanceof UserIDPacket) {
                    UserIDPacket id = (UserIDPacket)this.ids.get(i);
                    out.writePacket(id);
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (!forTransfer && this.idTrusts.get(i) != null) {
                    out.writePacket(this.idTrusts.get(i));
                }
                List<PGPSignature> sigs = this.idSigs.get(i);
                for (int j = 0; j != sigs.size(); ++j) {
                    sigs.get(j).encode(out, forTransfer);
                }
            }
        } else {
            for (int j = 0; j != this.subSigs.size(); ++j) {
                this.subSigs.get(j).encode(out, forTransfer);
            }
        }
    }

    public boolean isRevoked() {
        return this.hasRevocation();
    }

    public boolean hasRevocation() {
        int ns = 0;
        boolean revoked = false;
        if (this.isMasterKey()) {
            while (!revoked && ns < this.keySigs.size()) {
                if (this.keySigs.get(ns++).getSignatureType() != 32) continue;
                revoked = true;
            }
        } else {
            while (!revoked && ns < this.subSigs.size()) {
                if (this.subSigs.get(ns++).getSignatureType() != 40) continue;
                revoked = true;
            }
        }
        return revoked;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, byte[] rawID, PGPSignature certification) {
        return PGPPublicKey.addCert(key, new UserIDPacket(rawID), certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.addCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.addCert(key, userAttributes, certification);
    }

    private static PGPPublicKey addCert(PGPPublicKey key, Object id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        List<PGPSignature> sigList = null;
        for (int i = 0; i != returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            sigList = returnKey.idSigs.get(i);
        }
        if (sigList != null) {
            sigList.add(certification);
        } else {
            sigList = new ArrayList<PGPSignature>();
            sigList.add(certification);
            returnKey.ids.add(id);
            returnKey.idTrusts.add(null);
            returnKey.idSigs.add(sigList);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes) {
        return PGPPublicKey.removeCert(key, userAttributes);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id));
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, byte[] rawID) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(rawID));
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, Object id) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        for (int i = 0; i < returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            found = true;
            returnKey.ids.remove(i);
            returnKey.idTrusts.remove(i);
            returnKey.idSigs.remove(i);
        }
        if (!found) {
            return null;
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, byte[] id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, userAttributes, certification);
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, Object id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        for (int i = 0; i < returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            found = returnKey.idSigs.get(i).remove(certification);
        }
        if (!found) {
            return null;
        }
        return returnKey;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPSignature certification) {
        if (key.isMasterKey()) {
            if (certification.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (certification.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey returnKey = new PGPPublicKey(key);
        if (returnKey.subSigs != null) {
            returnKey.subSigs.add(certification);
        } else {
            returnKey.keySigs.add(certification);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = returnKey.subSigs != null ? returnKey.subSigs.remove(certification) : returnKey.keySigs.remove(certification);
        if (!found) {
            Iterator<PGPSignature> sIt;
            Iterator<Object> it = key.getRawUserIDs();
            while (it.hasNext()) {
                byte[] rawID = it.next();
                sIt = key.getSignaturesForID(rawID);
                while (sIt.hasNext()) {
                    if (certification != sIt.next()) continue;
                    found = true;
                    returnKey = PGPPublicKey.removeCertification(returnKey, rawID, certification);
                }
            }
            if (!found) {
                it = key.getUserAttributes();
                while (it.hasNext()) {
                    PGPUserAttributeSubpacketVector id = (PGPUserAttributeSubpacketVector)it.next();
                    sIt = key.getSignaturesForUserAttribute(id);
                    while (sIt.hasNext()) {
                        if (certification != sIt.next()) continue;
                        found = true;
                        returnKey = PGPPublicKey.removeCertification(returnKey, id, certification);
                    }
                }
            }
        }
        return returnKey;
    }
}

