/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.tls.AbstractTlsKeyExchange;
import net.savignano.thirdparty.org.bouncycastle.tls.Certificate;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsCredentialedAgreement;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsCredentials;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCertificate;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate ecdhPeerCertificate;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 16: 
            case 18: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHKeyExchange(int keyExchange) {
        super(TlsECDHKeyExchange.checkKeyExchange(keyExchange));
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(serverCredentials);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.ecdhPeerCertificate = serverCertificate.getCertificateAt(0).checkUsageInRole(2);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{66, 65};
    }

    public void skipClientCredentials() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(clientCredentials);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
    }

    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        this.ecdhPeerCertificate = clientCertificate.getCertificateAt(0).checkUsageInRole(2);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
    }

    public boolean requiresCertificateVerify() {
        return false;
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreementCredentials.generateAgreement(this.ecdhPeerCertificate);
    }
}

