/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce;

import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHMAC;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHash;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class JcaSSL3HMAC
implements TlsHMAC {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = JcaSSL3HMAC.genPad((byte)54, 48);
    private static final byte[] OPAD = JcaSSL3HMAC.genPad((byte)92, 48);
    private TlsHash digest;
    private final int digestSize;
    private final int internalBlockSize;
    private int padLength;
    private byte[] secret;

    JcaSSL3HMAC(TlsHash digest, int digestSize, int internalBlockSize) {
        this.digest = digest;
        this.digestSize = digestSize;
        this.internalBlockSize = internalBlockSize;
        this.padLength = digestSize == 20 ? 40 : 48;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.secret = TlsUtils.copyOfRangeExact(key, keyOff, keyOff + keyLen);
        this.reset();
    }

    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    public byte[] calculateMAC() {
        byte[] tmp = this.digest.calculateHash();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(OPAD, 0, this.padLength);
        this.digest.update(tmp, 0, tmp.length);
        byte[] result = this.digest.calculateHash();
        this.reset();
        return result;
    }

    public void calculateMAC(byte[] output, int outOff) {
        byte[] result = this.calculateMAC();
        System.arraycopy(result, 0, output, outOff, result.length);
    }

    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    public int getMacLength() {
        return this.digestSize;
    }

    public void reset() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(IPAD, 0, this.padLength);
    }

    private static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, b);
        return padding;
    }
}

