/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.x509;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.savignano.thirdparty.org.bouncycastle.util.Selector;
import net.savignano.thirdparty.org.bouncycastle.x509.ExtendedPKIXParameters;
import net.savignano.thirdparty.org.bouncycastle.x509.X509CertStoreSelector;

public class ExtendedPKIXBuilderParameters
extends ExtendedPKIXParameters {
    private int maxPathLength = 5;
    private Set excludedCerts = Collections.EMPTY_SET;

    public Set getExcludedCerts() {
        return Collections.unmodifiableSet(this.excludedCerts);
    }

    public void setExcludedCerts(Set excludedCerts) {
        if (excludedCerts == null) {
            excludedCerts = Collections.EMPTY_SET;
        } else {
            this.excludedCerts = new HashSet(excludedCerts);
        }
    }

    public ExtendedPKIXBuilderParameters(Set trustAnchors, Selector targetConstraints) throws InvalidAlgorithmParameterException {
        super(trustAnchors);
        this.setTargetConstraints(targetConstraints);
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new InvalidParameterException("The maximum path length parameter can not be less than -1.");
        }
        this.maxPathLength = maxPathLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    protected void setParams(PKIXParameters params) {
        PKIXParameters _params;
        super.setParams(params);
        if (params instanceof ExtendedPKIXBuilderParameters) {
            _params = (ExtendedPKIXBuilderParameters)params;
            this.maxPathLength = ((ExtendedPKIXBuilderParameters)_params).maxPathLength;
            this.excludedCerts = new HashSet(((ExtendedPKIXBuilderParameters)_params).excludedCerts);
        }
        if (params instanceof PKIXBuilderParameters) {
            _params = (PKIXBuilderParameters)params;
            this.maxPathLength = ((PKIXBuilderParameters)_params).getMaxPathLength();
        }
    }

    public Object clone() {
        ExtendedPKIXBuilderParameters params = null;
        try {
            params = new ExtendedPKIXBuilderParameters(this.getTrustAnchors(), this.getTargetConstraints());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        params.setParams(this);
        return params;
    }

    public static ExtendedPKIXParameters getInstance(PKIXParameters pkixParams) {
        ExtendedPKIXBuilderParameters params;
        try {
            params = new ExtendedPKIXBuilderParameters(pkixParams.getTrustAnchors(), X509CertStoreSelector.getInstance((X509CertSelector)pkixParams.getTargetCertConstraints()));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        params.setParams(pkixParams);
        return params;
    }
}

