/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import org.slf4j.Logger;

public class SmimeDecryptionKeyStoreLoader
extends AKeyLoader<SmimeDecryptionKey, KeyTransRecipientId> {
    private final KeyStore keyStore;
    private final char[] password;

    public SmimeDecryptionKeyStoreLoader(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SmimeDecryptionKey loadInternalKey(KeyTransRecipientId forId) throws Exception {
        Optional<Map.Entry<X509Certificate, PrivateKey>> privateKey;
        String keyId = this.getKeyId(forId);
        Logger log = this.getLog();
        log.debug("Looking up private key in key store (size {}) with ID: {}", (Object)this.keyStore.size(), (Object)keyId);
        KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(this.keyStore);
        fetcher.keyPassword(this.password);
        try {
            privateKey = fetcher.getEntryFor(c -> c.getSerialNumber().equals(forId.getSerialNumber()) && SmimeUtil.getIssuer(c).equals(forId.getIssuer()));
        }
        finally {
            fetcher.destroy();
        }
        if (!privateKey.isPresent()) {
            log.debug("Found no private key in key store with ID: {}", (Object)keyId);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Found private key in key store with ID: {}", (Object)keyId);
        SmimeDecryptionKey key = new SmimeDecryptionKey(privateKey.get().getValue(), privateKey.get().getKey());
        key.setKeySource(this.getKeySource());
        return key;
    }

    private String getKeyId(KeyTransRecipientId id) {
        return SmimeUtil.getSerialNumber(id.getSerialNumber()) + " from " + id.getIssuer();
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimeDecryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeDecryptionKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimeDecryptionKeyStoreLoader [keyStore=" + this.keyStore + ", password=*****]";
    }
}

