/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.decrypt;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.mail.IKeyProvider;
import net.savignano.cryptography.mail.decrypt.AMailDecryptor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.Recipient;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnveloped;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailDecryptor
extends AMailDecryptor<SmimeDecryptionKey, KeyTransRecipientId> {
    public static final boolean isMessageEncrypted(Message message) {
        return SmimeMailDecryptor.isMessageEncrypted((Part)message);
    }

    private static final boolean isMessageEncrypted(Part part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) {
                String smimeType = type.getParameter("smime-type");
                if (smimeType != null) {
                    return "enveloped-data".equalsIgnoreCase(smimeType);
                }
                return SmimeMailDecryptor.checkAsn1Type(part);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SmimeMailDecryptor.class).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static final boolean checkAsn1Type(Part part) throws IOException, MessagingException {
        ASN1Primitive asn1;
        try (ASN1InputStream is = new ASN1InputStream(part.getInputStream());){
            asn1 = is.readObject();
        }
        ContentInfo info = ContentInfo.getInstance(asn1);
        return info != null && "1.2.840.113549.1.7.3".equals(info.getContentType().toString());
    }

    public SmimeMailDecryptor(Session session) {
        super(session, ECryptographyType.SMIME);
    }

    @Override
    protected void decrypt(MimeMessage msg, IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> keyProvider) throws Exception {
        if (!SmimeMailDecryptor.isMessageEncrypted((Message)msg)) {
            this.getLog().debug("Message is not S/MIME encrypted. Content type encountered: {}", (Object)msg.getContentType());
            return;
        }
        String msgId = MessageUtil.getMessageId(msg);
        SMIMEEnveloped enveloped = new SMIMEEnveloped(msg);
        ASN1ObjectIdentifier symAlgorithm = enveloped.getContentEncryptionAlgorithm().getAlgorithm();
        this.getLog().debug("Used symmetric encryption algorithm: {}", (Object)SmimeUtil.getCmsName(symAlgorithm));
        if (!SmimeUtil.isSupportedSymmetricKeyAlgorithm(symAlgorithm)) {
            throw new MessagingException("Algorithm " + SmimeUtil.getCmsName(symAlgorithm) + " that was used to encrypt Email with ID " + msgId + " is not supported.");
        }
        RecipientInformation recipientInfo = null;
        SmimeDecryptionKey decKey = new SmimeDecryptionKey(EKeyValidity.NOT_FOUND);
        RecipientInformationStore recipientInfos = enveloped.getRecipientInfos();
        for (RecipientInformation info : recipientInfos.getRecipients()) {
            decKey = this.getDecryptionKey(info, keyProvider);
            if (!decKey.isValid()) continue;
            this.getLog().debug("Used asymmetric encryption algorithm: {}", (Object)SmimeUtil.getCmsName(info.getKeyEncryptionAlgorithm().getAlgorithm()));
            recipientInfo = info;
            break;
        }
        if (!decKey.isValid()) {
            this.throwRecipientCertificateNotFoundException(msgId, recipientInfos);
        }
        JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(decKey.getKey());
        this.decrypt(msg, recipientInfo, recipient);
        this.includeDecryptionHeader(msg);
        msg.saveChanges();
    }

    @Override
    protected IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> toProvider(SmimeDecryptionKey key) {
        return id -> {
            X509Certificate cert = key.getCertificate();
            if (cert != null && cert.getSerialNumber().equals(id.getSerialNumber()) && SmimeUtil.getIssuer(cert).equals(id.getIssuer())) {
                return key;
            }
            return new SmimeDecryptionKey(EKeyValidity.NOT_FOUND);
        };
    }

    private SmimeDecryptionKey getDecryptionKey(RecipientInformation info, IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> keyProvider) throws GeneralSecurityException {
        Logger log = this.getLog();
        if (info.getRID().getType() != 0) {
            log.debug("Recipient Info {} is not of type Key Transport (0), but {}", (Object)info.getRID(), (Object)info.getRID().getType());
            return new SmimeDecryptionKey(EKeyValidity.INVALID);
        }
        KeyTransRecipientId recipientId = (KeyTransRecipientId)info.getRID();
        String keyId = this.getKeyId(recipientId);
        if (!SmimeUtil.isSupportedAsymmetricKeyAlgorithm(info.getKeyEncryptionAlgorithm().getAlgorithm())) {
            log.warn("Key {} cannot be used for decryption, as the asymmetric algorith is not supported. Used algorithm: {}", (Object)keyId, (Object)SmimeUtil.getCmsName(info.getKeyEncryptionAlgorithm().getAlgorithm()));
            return new SmimeDecryptionKey(EKeyValidity.ERROR);
        }
        return keyProvider.getKey(recipientId);
    }

    private void throwRecipientCertificateNotFoundException(String msgId, RecipientInformationStore recipientInfos) throws MessagingException {
        String keyIds = null;
        for (RecipientInformation info : recipientInfos.getRecipients()) {
            RecipientId id = info.getRID();
            this.getLog().debug("Recipient Type encountered: {}", (Object)this.getRecipientType(id));
            if (id.getType() != 0 || !(id instanceof KeyTransRecipientId)) continue;
            String keyId = this.getKeyId((KeyTransRecipientId)id);
            this.getLog().debug("Key ID: {}", (Object)keyId);
            if (keyIds == null) {
                keyIds = keyId;
                continue;
            }
            keyIds = keyIds + ", " + keyId;
        }
        if (keyIds == null) {
            keyIds = "<N/A>";
        }
        throw new MessagingException("Found no valid private key in Key Store to decrypt Email with ID " + msgId + ". Certificate(s) used to encrypt email have ID(s): " + keyIds);
    }

    private String getKeyId(KeyTransRecipientId id) {
        return SmimeUtil.getSerialNumber(id.getSerialNumber()) + " from " + id.getIssuer();
    }

    private void decrypt(MimeMessage msg, RecipientInformation recipientInfo, Recipient recipient) throws SMIMEException, CMSException, MessagingException, IOException {
        this.getLog().debug("Decrypting content.");
        MimeBodyPart decryptedPart = SMIMEUtil.toMimeBodyPart(recipientInfo.getContent(recipient));
        msg.setDisposition(null);
        msg.removeHeader("Content-Transfer-Encoding");
        ByteArrayDataSource ds = new ByteArrayDataSource(decryptedPart.getInputStream(), decryptedPart.getContentType());
        msg.setDataHandler(new DataHandler((DataSource)ds));
        MessageUtil.copyAllHeaders((Part)decryptedPart, (Part)msg);
    }

    private String getRecipientType(RecipientId id) {
        switch (id.getType()) {
            case 0: {
                return "KeyTrans";
            }
            case 1: {
                return "Kek";
            }
            case 2: {
                return "KeyAgree";
            }
            case 3: {
                return "Password";
            }
        }
        return "<N/A>";
    }
}

