/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.mail.encrypt.PgpMailEncryptor;
import net.savignano.cryptography.mail.visitor.ManipulateMessageVisitor;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import org.apache.commons.io.IOUtils;

public class InlinePgpMailEncryptor
extends PgpMailEncryptor {
    private boolean binaryAttachment;

    public InlinePgpMailEncryptor(Session session) {
        super(session);
    }

    @Override
    protected void encrypt(MimeMessage msg, final PgpPublicKey key) throws IOException, MessagingException {
        ManipulateMessageVisitor visitor = new ManipulateMessageVisitor(){

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (part.isMimeType("text/plain")) {
                    this.encryptText(part);
                    this.setChanged(true);
                } else if ("attachment".equalsIgnoreCase(part.getDisposition())) {
                    if (InlinePgpMailEncryptor.this.isBinaryAttachment()) {
                        this.encryptAttachmentBinary(part);
                    } else {
                        this.encryptAttachmentArmored(part);
                    }
                    this.setChanged(true);
                }
            }

            private void encryptText(MimePart part) throws MessagingException, IOException, PGPException {
                this.getLog().debug("Found text/plain to encrypt.");
                ContentType contentType = new ContentType(part.getContentType());
                String text = (String)part.getContent();
                String charset = contentType.getParameter("charset");
                charset = charset == null ? "US-ASCII" : charset;
                byte[] encrypted = PgpUtil.encrypt(text.getBytes(charset), key.getKey(), InlinePgpMailEncryptor.this.getSymmetricKeyAlgorithm(key), true, true);
                part.setText(new String(encrypted, Constants.ASCII_CHARSET), charset);
            }

            private void encryptAttachmentBinary(MimePart part) throws MessagingException, IOException, PGPException {
                this.getLog().debug("Found attachment to encrypt. Binary style.");
                String filename = part.getFileName();
                filename = filename != null ? filename + ".pgp" : "attachment.pgp";
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (InputStream is = part.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                byte[] encrypted = PgpUtil.encrypt(os.toByteArray(), InlinePgpMailEncryptor.this.getUsedKeys(key), InlinePgpMailEncryptor.this.getSymmetricKeyAlgorithm(key), false, true);
                ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encrypted, "application/octet-stream");
                part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
                part.setFileName(filename);
            }

            private void encryptAttachmentArmored(MimePart part) throws MessagingException, IOException, PGPException {
                this.getLog().debug("Found attachment to encrypt. Ascii armored style.");
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (InputStream is = part.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                byte[] encrypted = PgpUtil.encrypt(os.toByteArray(), InlinePgpMailEncryptor.this.getUsedKeys(key), InlinePgpMailEncryptor.this.getSymmetricKeyAlgorithm(key), true, true);
                ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encrypted, part.getContentType());
                part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
            }
        };
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        if (visitor.isChanged()) {
            String cipherName = PgpUtil.getSymmetricCipherName(this.getSymmetricKeyAlgorithm(key));
            this.includeEncryptionHeader(msg, cipherName);
            msg.saveChanges();
        } else {
            this.getLog().warn("Found no text/plain content part, nor an attachment in message with ID {}. Nothing was encrypted.", (Object)msg.getMessageID());
        }
    }

    public boolean isBinaryAttachment() {
        return this.binaryAttachment;
    }

    public void setBinaryAttachment(boolean binaryAttachment) {
        this.binaryAttachment = binaryAttachment;
    }
}

