/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.validate;

import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.smime.SmimePublicKey;
import net.savignano.cryptography.mail.validate.AMailValidator;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformationVerifier;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.i18n.ErrorBundle;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.validator.SignedMailValidator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import net.savignano.thirdparty.org.bouncycastle.x509.PKIXCertPathReviewer;
import org.slf4j.LoggerFactory;

public class SmimeMailValidator
extends AMailValidator<SmimePublicKey> {
    private final PKIXParameters pkixParams;

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        MimePart part = (MimePart)message;
        return SmimeMailValidator.isMessageTransparentSigned(part) || SmimeMailValidator.isMessageOpaqueSigned(part);
    }

    public static final boolean isMessageOpaqueSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        return SmimeMailValidator.isMessageOpaqueSigned((MimePart)message);
    }

    public static final boolean isMessageTransparentSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        return SmimeMailValidator.isMessageTransparentSigned((MimePart)message);
    }

    private static final boolean isMessageOpaqueSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) {
                String smimeType = type.getParameter("smime-type");
                if (smimeType != null) {
                    return "signed-data".equalsIgnoreCase(smimeType);
                }
                return SmimeMailValidator.checkAsn1Type(part);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SmimeMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static final boolean checkAsn1Type(MimePart part) throws IOException, MessagingException {
        ASN1Primitive asn1;
        try (ASN1InputStream is = new ASN1InputStream(part.getInputStream());){
            asn1 = is.readObject();
        }
        ContentInfo info = ContentInfo.getInstance(asn1);
        return info != null && "1.2.840.113549.1.7.2".equals(info.getContentType().toString());
    }

    private static final boolean isMessageTransparentSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && (protocol.equals("application/pkcs7-signature") || protocol.equals("application/x-pkcs7-signature"));
            }
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(SmimeMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public SmimeMailValidator(Session session, PKIXParameters pkixParams) {
        super(session, ECryptographyType.SMIME);
        this.pkixParams = pkixParams;
    }

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.CAN_VALIDATE, EValidationType.SIGNATURE, EValidationType.TRUST);
    }

    @Override
    protected SmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SmimePublicKey(validity, EKeySource.EMAIL);
    }

    @Override
    protected boolean isSigned(MimeMessage msg) throws Exception {
        return SmimeMailValidator.isMessageSigned((Message)msg);
    }

    @Override
    protected boolean validate(MimeMessage msg, Set<EValidationType> validations, String email) throws Exception {
        ValidateVisitor visitor = new ValidateVisitor(this.pkixParams, validations);
        visitor.visit(msg);
        return (Boolean)visitor.getResult();
    }

    @Override
    protected SmimePublicKey extract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor(email);
        visitor.visit(msg);
        X509Certificate cert = (X509Certificate)visitor.getResult();
        if (cert == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        SmimePublicKey key = new SmimePublicKey(cert, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    private static final class ExtractVisitor
    extends Visitor<X509Certificate> {
        private final String email;

        public ExtractVisitor(String email) {
            this.email = email;
        }

        @Override
        public void handle(SMIMESigned signed) throws Exception {
            this.getLog().debug("Extracting public key for email: {}", (Object)this.email);
            Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
            KeyStore keyStore = SmimeUtil.convertToKeyStore(certificateHolders, "PKCS12", null);
            this.setResult(SmimeUtil.getValidCertForEmail(keyStore, this.email, EKeyPurpose.ENCRYPTION));
        }
    }

    private static final class ValidateVisitor
    extends Visitor<Boolean> {
        private final PKIXParameters pkixParams;
        private final Set<EValidationType> validations;

        public ValidateVisitor(PKIXParameters pkixParams, Set<EValidationType> validations) {
            this.pkixParams = pkixParams;
            this.validations = validations;
        }

        @Override
        public void visit(MimeMessage msg) throws Exception {
            this.setResult(false);
            this.getLog().debug("Validation types desired: {}", this.validations);
            if (this.pkixParams != null) {
                this.pkixParams.setDate(msg.getSentDate());
                this.handle(new SignedMailValidator(msg, this.pkixParams));
            } else {
                super.visit(msg);
            }
        }

        private void handle(SignedMailValidator validator) throws SignedMailValidatorException {
            if (this.validations.contains((Object)EValidationType.CAN_VALIDATE) && this.validations.size() == 1) {
                this.setResult(true);
                return;
            }
            this.getLog().debug("Validating message.");
            Iterator<SignerInformation> it = validator.getSignerInformationStore().getSigners().iterator();
            boolean valid = it.hasNext();
            while (valid && it.hasNext()) {
                SignerInformation signerInfo = it.next();
                String serialNumber = SmimeUtil.getSerialNumber(signerInfo.getSID().getSerialNumber());
                this.getLog().debug("Checking signature for certificate with serial number: {}", (Object)serialNumber);
                SignedMailValidator.ValidationResult result = validator.getValidationResult(signerInfo);
                if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                    valid = result.isVerifiedSignature();
                }
                if (valid && this.validations.contains((Object)EValidationType.TRUST)) {
                    if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                        valid = result.isValidSignature();
                    } else {
                        PKIXCertPathReviewer review = result.getCertPathReview();
                        boolean bl = valid = review != null && review.isValidCertPath();
                    }
                }
                if (!valid && this.getLog().isWarnEnabled()) {
                    this.logValidationResult(result, signerInfo);
                    continue;
                }
                this.getLog().debug("Signature check successful: {}", (Object)valid);
            }
            this.setResult(valid);
            this.getLog().debug("Validation finished.");
        }

        private void logValidationResult(SignedMailValidator.ValidationResult result, SignerInformation signerInfo) {
            X509Certificate cert;
            PKIXCertPathReviewer review = result.getCertPathReview();
            List<? extends Certificate> certPathCerts = result.getCertPath().getCertificates();
            StringBuilder builder = new StringBuilder(500);
            builder.append("Validation for signer with certificate ID ");
            builder.append(SmimeUtil.getSerialNumber(signerInfo.getSID().getSerialNumber()));
            builder.append(" failed. Verified signature: ");
            builder.append(result.isVerifiedSignature());
            builder.append(". Cert path valid: ");
            builder.append(review.isValidCertPath());
            builder.append("\n");
            builder.append("  Validation errors: ");
            List errors = result.getErrors();
            this.logErrors(errors, builder);
            builder.append("  Cert path (length ");
            builder.append(certPathCerts.size());
            builder.append(")\n");
            if (certPathCerts.size() != 0) {
                for (int i = 0; i < certPathCerts.size(); ++i) {
                    cert = (X509Certificate)certPathCerts.get(i);
                    builder.append("    Cert ");
                    builder.append(i);
                    builder.append(": ");
                    builder.append(cert.getSubjectX500Principal());
                    builder.append("\" with ID ");
                    builder.append(SmimeUtil.getSerialNumber(cert));
                    builder.append("\n");
                }
                X509Certificate lastCert = (X509Certificate)certPathCerts.get(certPathCerts.size() - 1);
                builder.append("    Expected: ");
                builder.append(lastCert.getIssuerX500Principal());
                builder.append("\n");
            }
            builder.append("  Cert path validation errors:\n");
            for (int i = -1; i < certPathCerts.size(); ++i) {
                if (i == -1) {
                    builder.append("    Global errors: ");
                } else {
                    cert = (X509Certificate)certPathCerts.get(i);
                    builder.append("    Errors for cert \"");
                    builder.append(cert.getSubjectX500Principal());
                    builder.append("\" with ID ");
                    builder.append(SmimeUtil.getSerialNumber(cert));
                    builder.append(": ");
                }
                this.logErrors(review.getErrors(i), builder);
            }
            this.getLog().warn(builder.toString());
        }

        private void logErrors(List<ErrorBundle> errors, StringBuilder builder) {
            switch (errors.size()) {
                case 0: {
                    builder.append("No errors reported.\n");
                    break;
                }
                case 1: {
                    this.logErrorBundle(errors.get(0), builder);
                    builder.append("\n");
                    break;
                }
                default: {
                    builder.append("\n");
                    for (ErrorBundle error : errors) {
                        this.logErrorBundle(error, builder);
                        builder.append("\n");
                    }
                }
            }
        }

        private void logErrorBundle(ErrorBundle error, StringBuilder builder) {
            builder.append(error.getId());
            builder.append(": ");
            builder.append(error.getSummary(Locale.ENGLISH));
        }

        @Override
        public void handle(SMIMESigned signed) throws Exception {
            this.getLog().debug("Validating signed part.");
            Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
            Iterator<SignerInformation> signerInformations = signed.getSignerInfos().getSigners().iterator();
            boolean valid = signerInformations.hasNext();
            while (valid && signerInformations.hasNext()) {
                SignerInformation signerInformation = signerInformations.next();
                this.getLog().debug("Checking signer ID for certificate with serial number: {}", (Object)signerInformation.getSID().getSerialNumber());
                X509CertificateHolder holder = certificateHolders.getMatches(signerInformation.getSID()).iterator().next();
                JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
                builder.setProvider(SecurityUtil.getProvider());
                SignerInformationVerifier verifier = builder.build(holder);
                valid = signerInformation.verify(verifier);
            }
            this.setResult(valid);
        }
    }

    private static abstract class Visitor<T>
    extends ResultMessageVisitor<T> {
        private Visitor() {
        }

        @Override
        protected void handlePart(MimePart part) throws Exception {
            ContentType type = new ContentType(part.getContentType());
            this.getLog().trace("MIME type: {}", (Object)type);
            if (SmimeMailValidator.isMessageTransparentSigned(part)) {
                this.getLog().debug("Found '{}' content.", (Object)type);
                MimeMultipart mp = (MimeMultipart)part.getContent();
                String encoding = part.getEncoding();
                SMIMESigned signed = encoding == null ? new SMIMESigned(mp) : new SMIMESigned(mp, encoding);
                this.handle(signed);
            } else if (SmimeMailValidator.isMessageOpaqueSigned(part)) {
                this.getLog().debug("Found '{}' content.", (Object)type);
                SMIMESigned signed = new SMIMESigned((Part)part);
                this.handle(signed);
            }
        }

        public abstract void handle(SMIMESigned var1) throws Exception;
    }
}

