/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.pgp.PgpPublicKeyStoreLoader;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpEncryptionKeyManager
extends AKeyManager<PgpPublicKey, String> {
    private static final Logger log = LoggerFactory.getLogger(PgpEncryptionKeyManager.class);
    private static final Map<String, PgpPublicKey> keyCache = new HashMap<String, PgpPublicKey>();
    private static final Map<String, Calendar> timeCache = new HashMap<String, Calendar>();

    public PgpEncryptionKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
    }

    @Override
    protected PgpPublicKey getCachedKey(String address) {
        return keyCache.getOrDefault(address, this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
    }

    @Override
    protected void setCachedKey(String address, PgpPublicKey key) throws IOException {
        if (key != null) {
            keyCache.put(address, key);
        } else {
            keyCache.remove(address);
        }
        timeCache.put(address, Calendar.getInstance());
    }

    @Override
    protected boolean isCacheAutomaticallyExpired(String address) {
        if (super.isCacheAutomaticallyExpired(address)) {
            return true;
        }
        Calendar cachedTimeStamp = this.getCachedTimeStamp(address);
        if (cachedTimeStamp == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (Calendar.getInstance().get(5) != cachedTimeStamp.get(5)) {
            log.debug("Cache automatically expired: New day.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired(String address) {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired(address)) {
            return true;
        }
        Calendar cachedTimeStamp = this.getCachedTimeStamp(address);
        if (cachedTimeStamp != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > cachedTimeStamp.getTimeInMillis()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpPublicKey, String>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpPublicKey, String>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpPublicKey, String>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        return loaders;
    }

    private Optional<IKeyLoader<PgpPublicKey, String>> createKeyStoreLoader() {
        PGPPublicKeyRingCollection keyRings;
        ISnotifyAppProperties appProps = this.getAppProps();
        String location = appProps.getString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No PGP key store configured to retrieve PGP private keys from.");
            return Optional.empty();
        }
        log.debug("PGP key store configured: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            keyRings = PgpUtil.loadPublicKeys(in);
        }
        catch (Exception e) {
            log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new PgpPublicKeyStoreLoader(keyRings));
    }

    @Override
    protected PgpPublicKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new PgpPublicKey(validity, keySource);
    }

    protected Calendar getCachedTimeStamp(String address) {
        return timeCache.get(address);
    }

    protected void setCachedTimeStamp(String address, Calendar cachedTimeStamp) {
        timeCache.put(address, cachedTimeStamp);
    }
}

