/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.DataLengthException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.OutputLengthException;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class PhotonBeetleDigest
implements Digest {
    private byte[] state;
    private byte[][] state_2d;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final int INITIAL_RATE_INBYTES = 16;
    private int RATE_INBYTES = 4;
    private int SQUEEZE_RATE_INBYTES = 16;
    private int STATE_INBYTES = 32;
    private int TAG_INBYTES = 32;
    private int LAST_THREE_BITS_OFFSET = 5;
    private int ROUND = 12;
    private int D = 8;
    private int Dq = 3;
    private int Dr = 7;
    private int DSquare = 64;
    private int S = 4;
    private int S_1 = 3;
    private byte[][] RC = new byte[][]{{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10}, {0, 2, 6, 15, 12, 10, 7, 13, 8, 3, 4, 11}, {2, 0, 4, 13, 14, 8, 5, 15, 10, 1, 6, 9}, {6, 4, 0, 9, 10, 12, 1, 11, 14, 5, 2, 13}, {14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5}, {15, 13, 9, 0, 3, 5, 8, 2, 7, 12, 11, 4}, {13, 15, 11, 2, 1, 7, 10, 0, 5, 14, 9, 6}, {9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2}};
    private byte[][] MixColMatrix = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
    private byte[] sbox = new byte[]{12, 5, 6, 11, 9, 0, 10, 13, 3, 14, 15, 8, 4, 7, 1, 2};

    public PhotonBeetleDigest() {
        this.state = new byte[this.STATE_INBYTES];
        this.state_2d = new byte[this.D][this.D];
    }

    public String getAlgorithmName() {
        return "Photon-Beetle Hash";
    }

    public int getDigestSize() {
        return this.TAG_INBYTES;
    }

    public void update(byte input) {
        this.buffer.write(input);
    }

    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(input, inOff, len);
    }

    public int doFinal(byte[] output, int outOff) {
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] input = this.buffer.toByteArray();
        int inlen = input.length;
        if (inlen == 0) {
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ 1 << this.LAST_THREE_BITS_OFFSET);
        } else if (inlen <= 16) {
            System.arraycopy(input, 0, this.state, 0, inlen);
            if (inlen < 16) {
                int n = inlen;
                this.state[n] = (byte)(this.state[n] ^ 1);
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ (inlen < 16 ? 1 : 2) << this.LAST_THREE_BITS_OFFSET);
        } else {
            int i;
            System.arraycopy(input, 0, this.state, 0, 16);
            int Dlen_inblocks = ((inlen -= 16) + this.RATE_INBYTES - 1) / this.RATE_INBYTES;
            for (i = 0; i < Dlen_inblocks - 1; ++i) {
                this.PHOTON_Permutation();
                this.XOR(input, 16 + i * this.RATE_INBYTES, this.RATE_INBYTES);
            }
            this.PHOTON_Permutation();
            int LastDBlocklen = inlen - i * this.RATE_INBYTES;
            this.XOR(input, 16 + i * this.RATE_INBYTES, LastDBlocklen);
            if (LastDBlocklen < this.RATE_INBYTES) {
                int n = LastDBlocklen;
                this.state[n] = (byte)(this.state[n] ^ 1);
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ (inlen % this.RATE_INBYTES == 0 ? 1 : 2) << this.LAST_THREE_BITS_OFFSET);
        }
        this.PHOTON_Permutation();
        System.arraycopy(this.state, 0, output, outOff, this.SQUEEZE_RATE_INBYTES);
        this.PHOTON_Permutation();
        System.arraycopy(this.state, 0, output, outOff + this.SQUEEZE_RATE_INBYTES, this.TAG_INBYTES - this.SQUEEZE_RATE_INBYTES);
        return this.TAG_INBYTES;
    }

    void XOR(byte[] in_right, int rOff, int iolen_inbytes) {
        for (int i = 0; i < iolen_inbytes; ++i) {
            int n = i;
            this.state[n] = (byte)(this.state[n] ^ in_right[i + rOff]);
        }
    }

    public void reset() {
        this.buffer.reset();
        Arrays.fill(this.state, (byte)0);
    }

    void PHOTON_Permutation() {
        int i;
        for (i = 0; i < this.DSquare; ++i) {
            this.state_2d[i >>> this.Dq][i & this.Dr] = (byte)((this.state[i >> 1] & 0xFF) >>> 4 * (i & 1) & 0xF);
        }
        for (int round = 0; round < this.ROUND; ++round) {
            int j;
            for (i = 0; i < this.D; ++i) {
                byte[] byArray = this.state_2d[i];
                byArray[0] = (byte)(byArray[0] ^ this.RC[i][round]);
            }
            for (i = 0; i < this.D; ++i) {
                for (j = 0; j < this.D; ++j) {
                    this.state_2d[i][j] = this.sbox[this.state_2d[i][j]];
                }
            }
            for (i = 1; i < this.D; ++i) {
                System.arraycopy(this.state_2d[i], 0, this.state, 0, this.D);
                System.arraycopy(this.state, i, this.state_2d[i], 0, this.D - i);
                System.arraycopy(this.state, 0, this.state_2d[i], this.D - i, i);
            }
            for (j = 0; j < this.D; ++j) {
                for (i = 0; i < this.D; ++i) {
                    byte sum = 0;
                    for (int k = 0; k < this.D; ++k) {
                        int x = this.MixColMatrix[i][k];
                        int ret = 0;
                        byte b = this.state_2d[k][j];
                        for (int l = 0; l < this.S; ++l) {
                            if ((b >>> l & 1) != 0) {
                                ret ^= x;
                            }
                            if ((x >>> this.S_1 & 1) != 0) {
                                x <<= 1;
                                x ^= 3;
                                continue;
                            }
                            x <<= 1;
                        }
                        sum = (byte)(sum ^ ret & 0xF);
                    }
                    this.state[i] = sum;
                }
                for (i = 0; i < this.D; ++i) {
                    this.state_2d[i][j] = this.state[i];
                }
            }
        }
        for (i = 0; i < this.DSquare; i += 2) {
            this.state[i >>> 1] = (byte)(this.state_2d[i >>> this.Dq][i & this.Dr] & 0xF | (this.state_2d[i >>> this.Dq][i + 1 & this.Dr] & 0xF) << 4);
        }
    }
}

