/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.DataLengthException;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.crypto.OutputLengthException;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.Utils;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.AEADCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithIV;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class XoodyakEngine
implements AEADCipher {
    private boolean forEncryption;
    private byte[] state;
    private int phase;
    private MODE mode;
    private int Rabsorb;
    private final int f_bPrime = 48;
    private final int Rkout = 24;
    private byte[] K;
    private byte[] iv;
    private final int PhaseDown = 1;
    private final int PhaseUp = 2;
    private final int NLANES = 12;
    private final int NROWS = 3;
    private final int NCOLUMS = 4;
    private final int MAXROUNDS = 12;
    private final int TAGLEN = 16;
    final int Rkin = 44;
    private byte[] tag;
    private final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private boolean aadFinished;
    private boolean encrypted;
    private boolean initialised = false;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Xoodyak init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        this.iv = ivParams.getIV();
        if (this.iv == null || this.iv.length != 16) {
            throw new IllegalArgumentException("Xoodyak requires exactly 16 bytes of IV");
        }
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Xoodyak init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        this.K = key.getKey();
        if (this.K.length != 16) {
            throw new IllegalArgumentException("Xoodyak key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.state = new byte[48];
        this.tag = new byte[16];
        this.initialised = true;
        this.reset();
    }

    public String getAlgorithmName() {
        return "Xoodyak AEAD";
    }

    public void processAADByte(byte input) {
        if (this.aadFinished) {
            throw new IllegalArgumentException("AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        this.aadData.write(input);
    }

    public void processAADBytes(byte[] input, int inOff, int len) {
        if (this.aadFinished) {
            throw new IllegalArgumentException("AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.aadData.write(input, inOff, len);
    }

    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    private void processAAD() {
        if (!this.aadFinished) {
            byte[] ad = this.aadData.toByteArray();
            this.AbsorbAny(ad, 0, ad.length, this.Rabsorb, 3);
            this.aadFinished = true;
        }
    }

    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (this.mode != MODE.ModeKeyed) {
            throw new IllegalArgumentException("Xoodyak has not been initialised");
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.message.write(input, inOff, len);
        int blockLen = this.message.size() - (this.forEncryption ? 0 : 16);
        if (blockLen >= this.getBlockSize()) {
            byte[] blocks = this.message.toByteArray();
            len = blockLen / this.getBlockSize() * this.getBlockSize();
            if (len + outOff > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.processAAD();
            this.encrypt(blocks, 0, len, output, outOff);
            this.message.reset();
            this.message.write(blocks, len, blocks.length - len);
            return len;
        }
        return 0;
    }

    private int encrypt(byte[] input, int inOff, int len, byte[] output, int outOff) {
        int splitLen;
        int Cu;
        byte[] P = new byte[24];
        int n = Cu = this.encrypted ? 0 : 128;
        for (int IOLen = len; IOLen != 0 || !this.encrypted; IOLen -= splitLen) {
            splitLen = Math.min(IOLen, 24);
            if (this.forEncryption) {
                System.arraycopy(input, inOff, P, 0, splitLen);
            }
            this.Up(null, 0, Cu);
            for (int i = 0; i < splitLen; ++i) {
                output[outOff + i] = (byte)(input[inOff++] ^ this.state[i]);
            }
            if (this.forEncryption) {
                this.Down(P, 0, splitLen, 0);
            } else {
                this.Down(output, outOff, splitLen, 0);
            }
            Cu = 0;
            outOff += splitLen;
            this.encrypted = true;
        }
        return len;
    }

    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        byte[] blocks = this.message.toByteArray();
        int len = this.message.size();
        if (this.forEncryption && len + 16 + outOff > output.length || !this.forEncryption && len - 16 + outOff > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processAAD();
        int rv = 0;
        if (this.forEncryption) {
            this.encrypt(blocks, 0, len, output, outOff);
            this.tag = new byte[16];
            this.Up(this.tag, 16, 64);
            System.arraycopy(this.tag, 0, output, outOff += len, 16);
            rv = len + 16;
        } else {
            int inOff;
            rv = inOff = len - 16;
            this.encrypt(blocks, 0, inOff, output, outOff);
            this.tag = new byte[16];
            this.Up(this.tag, 16, 64);
            for (int i = 0; i < 16; ++i) {
                if (this.tag[i] == blocks[inOff++]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.reset(false);
        return rv;
    }

    public byte[] getMac() {
        return this.tag;
    }

    public int getUpdateOutputSize(int len) {
        return len;
    }

    public int getOutputSize(int len) {
        return len + 16;
    }

    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.tag = null;
        }
        Arrays.fill(this.state, (byte)0);
        this.aadFinished = false;
        this.encrypted = false;
        this.phase = 2;
        this.message.reset();
        this.aadData.reset();
        int KLen = this.K.length;
        int IDLen = this.iv.length;
        byte[] KID = new byte[44];
        this.mode = MODE.ModeKeyed;
        this.Rabsorb = 44;
        System.arraycopy(this.K, 0, KID, 0, KLen);
        System.arraycopy(this.iv, 0, KID, KLen, IDLen);
        KID[KLen + IDLen] = (byte)IDLen;
        this.AbsorbAny(KID, 0, KLen + IDLen + 1, this.Rabsorb, 2);
    }

    private void AbsorbAny(byte[] X, int Xoff, int XLen, int r, int Cd) {
        int splitLen;
        do {
            if (this.phase != 2) {
                this.Up(null, 0, 0);
            }
            splitLen = Math.min(XLen, r);
            this.Down(X, Xoff, splitLen, Cd);
            Cd = 0;
            Xoff += splitLen;
        } while ((XLen -= splitLen) != 0);
    }

    private void Up(byte[] Yi, int YiLen, int Cu) {
        if (this.mode != MODE.ModeHash) {
            this.state[47] = (byte)(this.state[47] ^ Cu);
        }
        int[] a = new int[12];
        Pack.littleEndianToInt(this.state, 0, a, 0, a.length);
        int[] b = new int[12];
        int[] p = new int[4];
        int[] e = new int[4];
        for (int i = 0; i < 12; ++i) {
            int y;
            int x;
            for (x = 0; x < 4; ++x) {
                p[x] = a[this.index(x, 0)] ^ a[this.index(x, 1)] ^ a[this.index(x, 2)];
            }
            for (x = 0; x < 4; ++x) {
                y = p[x + 3 & 3];
                e[x] = this.ROTL32(y, 5) ^ this.ROTL32(y, 14);
            }
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 3; ++y) {
                    int n = this.index(x, y);
                    a[n] = a[n] ^ e[x];
                }
            }
            for (x = 0; x < 4; ++x) {
                b[this.index((int)x, (int)0)] = a[this.index(x, 0)];
                b[this.index((int)x, (int)1)] = a[this.index(x + 3, 1)];
                b[this.index((int)x, (int)2)] = this.ROTL32(a[this.index(x, 2)], 11);
            }
            b[0] = b[0] ^ this.RC[i];
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 3; ++y) {
                    a[this.index((int)x, (int)y)] = b[this.index(x, y)] ^ ~b[this.index(x, y + 1)] & b[this.index(x, y + 2)];
                }
            }
            for (x = 0; x < 4; ++x) {
                b[this.index((int)x, (int)0)] = a[this.index(x, 0)];
                b[this.index((int)x, (int)1)] = this.ROTL32(a[this.index(x, 1)], 1);
                b[this.index((int)x, (int)2)] = this.ROTL32(a[this.index(x + 2, 2)], 8);
            }
            System.arraycopy(b, 0, a, 0, 12);
        }
        Pack.intToLittleEndian(a, 0, a.length, this.state, 0);
        this.phase = 2;
        if (Yi != null) {
            System.arraycopy(this.state, 0, Yi, 0, YiLen);
        }
    }

    void Down(byte[] Xi, int XiOff, int XiLen, int Cd) {
        int i = 0;
        while (i < XiLen) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ Xi[XiOff++]);
        }
        int n = XiLen;
        this.state[n] = (byte)(this.state[n] ^ 1);
        this.state[47] = (byte)(this.state[47] ^ (this.mode == MODE.ModeHash ? Cd & 1 : Cd));
        this.phase = 1;
    }

    private int index(int x, int y) {
        return y % 3 * 4 + x % 4;
    }

    private int ROTL32(int a, int offset) {
        return a << (offset & 0x1F) ^ a >>> (32 - offset & 0x1F);
    }

    public int getBlockSize() {
        return 24;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        ModeHash,
        ModeKeyed;

    }
}

