/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.gpg.keybox.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobVerifier;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.jcajce.JcaBlobVerifier;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class JcaKeyBoxBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaKeyBoxBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaKeyBoxBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcaKeyBox build(InputStream input) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return new JcaKeyBox(input, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), (BlobVerifier)new JcaBlobVerifier(this.helper));
    }

    public JcaKeyBox build(byte[] encoding) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return new JcaKeyBox(encoding, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), (BlobVerifier)new JcaBlobVerifier(this.helper));
    }
}

