/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItsUtils {
    public static byte[] octetStringFixed(byte[] octets, int n) {
        if (octets.length != n) {
            throw new IllegalArgumentException("octet string out of range");
        }
        return octets;
    }

    public static byte[] octetStringFixed(byte[] octets) {
        if (octets.length < 1 || octets.length > 32) {
            throw new IllegalArgumentException("octet string out of range");
        }
        return Arrays.clone(octets);
    }

    public static ASN1Sequence toSequence(List objs) {
        return new DERSequence(objs.toArray(new ASN1Encodable[0]));
    }

    public static ASN1Sequence toSequence(ASN1Encodable ... objs) {
        return new DERSequence(objs);
    }

    @Deprecated
    public static <T> List<T> fillList(final Class<T> type, final ASN1Sequence sequence) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<T>>(){

            @Override
            public List<T> run() {
                try {
                    ArrayList accumulator = new ArrayList();
                    Iterator<ASN1Encodable> it = sequence.iterator();
                    while (it.hasNext()) {
                        Method m = type.getMethod("getInstance", Object.class);
                        accumulator.add(type.cast(m.invoke(null, it.next())));
                    }
                    return accumulator;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("could not invoke getInstance on type " + ex.getMessage(), ex);
                }
            }
        });
    }
}

