/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus;

import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.HarakaSBase;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.HarakaSXof;

class HarakaS512Digest
extends HarakaSBase
implements Digest {
    public HarakaS512Digest(HarakaSXof base) {
        this.haraka512_rc = base.haraka512_rc;
    }

    public String getAlgorithmName() {
        return "HarakaS-512";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        if (this.off > 63) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        this.buffer[this.off++] = in;
    }

    public void update(byte[] in, int inOff, int len) {
        if (this.off > 64 - len) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        System.arraycopy(in, inOff, this.buffer, this.off, len);
        this.off += len;
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] s = new byte[64];
        this.haraka512Perm(s);
        HarakaS512Digest.xor(s, 8, this.buffer, 8, out, outOff, 8);
        HarakaS512Digest.xor(s, 24, this.buffer, 24, out, outOff + 8, 16);
        HarakaS512Digest.xor(s, 48, this.buffer, 48, out, outOff + 24, 8);
        this.reset();
        return s.length;
    }

    public void reset() {
        super.reset();
    }
}

