/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.falcon;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.FalconPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.FalconPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.FalconParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class BCFalconPrivateKey
implements FalconPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient FalconPrivateKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;
    private transient ASN1Set attributes;

    public BCFalconPrivateKey(FalconPrivateKeyParameters params) {
        this.init(params, null);
    }

    public BCFalconPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.init((FalconPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo), keyInfo.getAttributes());
    }

    private void init(FalconPrivateKeyParameters params, ASN1Set attributes) {
        this.attributes = attributes;
        this.params = params;
        this.algorithm = Strings.toUpperCase(params.getParameters().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCFalconPrivateKey) {
            BCFalconPrivateKey otherKey = (BCFalconPrivateKey)o;
            return Arrays.areEqual(this.getEncoded(), otherKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedPrivateKeyInfo(this.params, this.attributes);
        }
        return Arrays.clone(this.encoding);
    }

    public FalconParameterSpec getParameterSpec() {
        return FalconParameterSpec.fromName(this.params.getParameters().getName());
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public FalconPublicKey getPublicKey() {
        return new BCFalconPublicKey(new FalconPublicKeyParameters(this.params.getParameters(), this.params.getPublicKey()));
    }

    FalconPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

