/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.hqc;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class HQCKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    HQCKeyGenerationParameters param;
    HQCKeyPairGenerator engine = new HQCKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public HQCKeyPairGeneratorSpi() {
        super("HQC");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = HQCKeyPairGeneratorSpi.getNameFromParams(params);
        if (name == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.param = new HQCKeyGenerationParameters(random, (HQCParameters)parameters.get(name));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof HQCParameterSpec) {
            HQCParameterSpec hqcParams = (HQCParameterSpec)paramSpec;
            return hqcParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new HQCKeyGenerationParameters(this.random, HQCParameters.hqc128);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        HQCPublicKeyParameters pub = (HQCPublicKeyParameters)pair.getPublic();
        HQCPrivateKeyParameters priv = (HQCPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCHQCPublicKey(pub), new BCHQCPrivateKey(priv));
    }

    static {
        parameters.put("hqc-128", HQCParameters.hqc128);
        parameters.put("hqc-192", HQCParameters.hqc192);
        parameters.put("hqc-256", HQCParameters.hqc256);
        parameters.put(HQCParameterSpec.hqc128.getName(), HQCParameters.hqc128);
        parameters.put(HQCParameterSpec.hqc192.getName(), HQCParameters.hqc192);
        parameters.put(HQCParameterSpec.hqc256.getName(), HQCParameters.hqc256);
    }
}

