/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.cert.CertificateException;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyBoxLoader;
import net.savignano.cryptography.key.smime.SmimePublicKey;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.CertificateBlob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;

public class SmimeKeyBoxLoader
extends AKeyBoxLoader<SmimePublicKey, CertificateBlob> {
    public SmimeKeyBoxLoader(KeyBox keyBox) {
        super(keyBox, BlobType.X509_BLOB);
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimePublicKey loadKeyFromBlob(CertificateBlob blob) throws Exception {
        SmimePublicKey key = new SmimePublicKey(SmimeUtil.createCertificate(blob.getEncodedCertificate()));
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    protected boolean isKeyForEmail(SmimePublicKey key, String email) {
        try {
            return SmimeUtil.isCertForEmail(key.getKey(), email);
        }
        catch (CertificateException e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    protected SmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SmimePublicKey(validity, this.getKeySource());
    }

    @Override
    public int compare(SmimePublicKey o1, SmimePublicKey o2) {
        int compared = super.compare(o1, o2);
        if (compared != 0) {
            return compared;
        }
        return SmimeUtil.getCertificateComparator().compare(o1.getKey(), o2.getKey());
    }
}

