/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.mail.ISessionProvider;
import net.savignano.cryptography.version.ProductInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMailCryptography<T extends ICryptographyKey<?>>
implements ISessionProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Session session;
    private final ECryptographyType cryptography;
    private ProductInformation productInfo;

    protected BaseMailCryptography(Session session, ECryptographyType cryptography) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (cryptography == null) {
            throw new IllegalArgumentException("Cryptography must not be null.");
        }
        this.session = session;
        this.cryptography = cryptography;
    }

    protected void includeCryptographyHeader(MimeMessage msg, String headerName, String valuePattern, Object ... additonalValues) throws MessagingException {
        ProductInformation info = this.getProductInfo();
        if (info == null) {
            return;
        }
        Object[] values = new Object[additonalValues.length + 3];
        values[0] = info.getProduct();
        values[1] = info.getVersion();
        values[2] = info.getHost();
        System.arraycopy(additonalValues, 0, values, 3, additonalValues.length);
        String headerValue = MessageFormat.format(valuePattern, values);
        try {
            String encodedHeaderValue = MimeUtility.fold((int)headerName.length(), (String)MimeUtility.encodeText((String)headerValue, (String)"UTF-8", null));
            msg.setHeader(headerName, encodedHeaderValue);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Could not encode \"" + headerValue + "\". Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void traceMessage(MimeMessage msg, String displayPattern) throws IOException, MessagingException {
        if (this.getLog().isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            String msgStr = baos.toString();
            if (displayPattern == null) {
                this.getLog().trace(msgStr);
            } else {
                this.getLog().trace(displayPattern, (Object)msgStr);
            }
        }
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public ECryptographyType getCryptography() {
        return this.cryptography;
    }

    public ProductInformation getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(ProductInformation productInfo) {
        this.productInfo = productInfo;
    }
}

