/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.validate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.mail.validate.AMailValidator;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.LoggerFactory;

public class PgpMailValidator
extends AMailValidator<PgpPublicKey> {
    private Function<String, IPublicCryptographyKey<PGPPublicKeyRingCollection>> validationKeyRetriever;
    private boolean checkInline;

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        return PgpMailValidator.isSigned((MimePart)message);
    }

    private static final boolean isSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && protocol.equalsIgnoreCase("application/pgp-signature");
            }
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(PgpMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static final boolean isMessageSignedInline(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        ResultMessageVisitor<Boolean> visitor = new ResultMessageVisitor<Boolean>(Boolean.valueOf(false)){
            {
                this.setContentType("text/plain");
            }

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (((Boolean)this.getResult()).booleanValue()) {
                    return;
                }
                Object content = part.getContent();
                this.setResult(content instanceof String && ((String)content).startsWith("-----BEGIN PGP SIGNED MESSAGE-----"));
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PgpMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return (Boolean)visitor.getResult();
    }

    public PgpMailValidator(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.CAN_VALIDATE, EValidationType.SIGNATURE);
    }

    @Override
    protected PgpPublicKey getValidityKey(EKeyValidity validity) {
        return new PgpPublicKey(validity, EKeySource.EMAIL);
    }

    @Override
    protected boolean isSigned(MimeMessage msg) throws Exception {
        return PgpMailValidator.isMessageSigned((Message)msg) || this.isCheckInline() && PgpMailValidator.isMessageSignedInline((Message)msg);
    }

    @Override
    protected boolean validate(MimeMessage msg, Set<EValidationType> validations, String email) throws Exception {
        IPublicCryptographyKey<PGPPublicKeyRingCollection> valKey = this.getPublicKeyRetriever().apply(email);
        ValidateVisitor visitor = new ValidateVisitor(validations, email, valKey.isValid() ? (PGPPublicKeyRingCollection)valKey.getKey() : null, this.isCheckInline());
        visitor.visit(msg);
        return (Boolean)visitor.getResult();
    }

    @Override
    protected PgpPublicKey extract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor(email);
        visitor.visit(msg);
        PGPPublicKeyRing ring = (PGPPublicKeyRing)visitor.getResult();
        if (ring == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        PgpPublicKey key = new PgpPublicKey(ring, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    public Function<String, IPublicCryptographyKey<PGPPublicKeyRingCollection>> getPublicKeyRetriever() {
        return this.validationKeyRetriever == null ? s -> new PgpValidationKey(EKeyValidity.NOT_FOUND) : this.validationKeyRetriever;
    }

    public void setPublicKeyRetriever(Function<String, IPublicCryptographyKey<PGPPublicKeyRingCollection>> publicKeyRetriever) {
        this.validationKeyRetriever = publicKeyRetriever;
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }

    private static final class ExtractVisitor
    extends ResultMessageVisitor<PGPPublicKeyRing> {
        private final String email;

        public ExtractVisitor(String email) {
            this.email = email;
        }

        @Override
        protected void handlePart(MimePart part) throws Exception {
            ContentType type = new ContentType(part.getContentType());
            this.getLog().trace("MIME type: {}", (Object)type);
            if (type.match("application/pgp-keys") || this.isKeyAttachment(part)) {
                this.getLog().debug("Extracting public key for email: {}", (Object)this.email);
                PGPPublicKeyRingCollection keys = PgpUtil.loadPublicKeys(part.getInputStream());
                this.setResult(PgpUtil.getKeysForEmail(keys, this.email));
            }
        }

        private boolean isKeyAttachment(MimePart part) throws MessagingException {
            String fileName;
            String disposition = part.getDisposition();
            return disposition != null && disposition.equalsIgnoreCase("attachment") && (fileName = part.getFileName()) != null && fileName.endsWith(".asc") && !part.isMimeType("application/pgp-encrypted") && !part.isMimeType("application/pgp-signature");
        }
    }

    private static final class ValidateVisitor
    extends ResultMessageVisitor<Boolean> {
        private final Set<EValidationType> validations;
        private final String email;
        private final boolean checkInline;
        private PGPPublicKeyRingCollection coll;

        public ValidateVisitor(Set<EValidationType> validations, String email, PGPPublicKeyRingCollection coll, boolean checkInline) {
            super(false);
            this.validations = validations;
            this.email = email;
            this.coll = coll;
            this.checkInline = checkInline;
        }

        @Override
        public void visit(MimeMessage msg) throws Exception {
            this.getLog().debug("Validation types desired: {}", this.validations);
            ExtractVisitor extractVisitor = new ExtractVisitor(this.email);
            extractVisitor.visit(msg);
            PGPPublicKeyRing ring = (PGPPublicKeyRing)extractVisitor.getResult();
            this.coll = this.combine(this.coll, ring);
            if (this.validations.contains((Object)EValidationType.CAN_VALIDATE) && this.validations.size() == 1) {
                this.setResult(this.coll != null);
            } else if (this.coll == null || this.coll.size() == 0) {
                this.getLog().warn("Cannot verify PGP signature, as no public key was available.");
            } else {
                super.visit(msg);
            }
        }

        private PGPPublicKeyRingCollection combine(PGPPublicKeyRingCollection oldColl, PGPPublicKeyRing ring) {
            if (ring == null) {
                return oldColl;
            }
            if (oldColl == null) {
                return new PGPPublicKeyRingCollection(Collections.singleton(ring));
            }
            if (oldColl.contains(ring.getPublicKey().getKeyID())) {
                return oldColl;
            }
            return PGPPublicKeyRingCollection.addPublicKeyRing(oldColl, ring);
        }

        @Override
        protected boolean isRelevant(ContentType type) {
            if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                if (type.match("multipart/signed") && "application/pgp-signature".equalsIgnoreCase(type.getParameter("protocol"))) {
                    return true;
                }
                if (this.checkInline && type.match("text/plain")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void handleMultipart(MimeMultipart mp) throws Exception {
            if (this.sanityCheck(mp)) {
                this.setResult(this.validate(mp));
            } else {
                this.setResult(false);
            }
        }

        @Override
        protected void handlePart(MimePart part) throws Exception {
            Object content = part.getContent();
            if (content instanceof String && ((String)content).startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
                this.setResult(this.validate(part));
            }
        }

        private boolean sanityCheck(MimeMultipart mp) throws MessagingException {
            if (mp.getCount() != 2) {
                this.getLog().warn("PGP signature does not have expected part count. Two expected, but found: {}", (Object)mp.getCount());
                return false;
            }
            if (!mp.getBodyPart(1).isMimeType("application/pgp-signature")) {
                this.getLog().warn("PGP signature does not have expected content type. Found: {}", (Object)mp.getBodyPart(1).getContentType());
                return false;
            }
            this.getLog().debug("Sanity check of PGP signature successful.");
            return true;
        }

        private boolean validate(MimeMultipart mp) throws Exception {
            this.getLog().debug("Validating message.");
            MimeBodyPart contentPart = (MimeBodyPart)mp.getBodyPart(0);
            MimeBodyPart sigPart = (MimeBodyPart)mp.getBodyPart(1);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            contentPart.writeTo((OutputStream)os);
            byte[] contentBytes = os.toByteArray();
            os.reset();
            sigPart.writeTo((OutputStream)os);
            byte[] sigBytes = os.toByteArray();
            return PgpUtil.verify(contentBytes, sigBytes, id -> this.coll.getPublicKey(id));
        }

        private boolean validate(MimePart part) throws Exception {
            this.getLog().debug("Validating inline message.");
            String fullContent = (String)part.getContent();
            String signature = this.getSignature(fullContent);
            String text = this.getTextRemoveHeaders(fullContent);
            if (PgpUtil.verify(text.getBytes(), signature.getBytes(), id -> this.coll.getPublicKey(id))) {
                return true;
            }
            String plainText = this.getText(fullContent);
            return PgpUtil.verify(plainText.getBytes(), signature.getBytes(), id -> this.coll.getPublicKey(id));
        }

        private String getText(String fullContent) {
            int startIndex = "-----BEGIN PGP SIGNED MESSAGE-----".length();
            int endIndex = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
            String cropped = fullContent.substring(startIndex, endIndex);
            return this.removeLinebreaks(cropped);
        }

        private String getTextRemoveHeaders(String fullContent) throws MessagingException, IOException {
            StringBuilder builder = new StringBuilder(fullContent.length());
            ContentType contentType = new ContentType("text/plain");
            contentType.setParameter("charset", "UTF-8");
            builder.append("Content-Type");
            builder.append(": ");
            builder.append(contentType.toString());
            builder.append("\r\n");
            builder.append(this.getText(fullContent));
            MimeBodyPart part = new MimeBodyPart((InputStream)new ByteArrayInputStream(builder.toString().getBytes(Constants.UTF8_CHARSET)));
            return (String)part.getContent();
        }

        private String getSignature(String fullContent) {
            int startSig = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
            return fullContent.substring(startSig);
        }

        private String removeLinebreaks(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            int start = str.startsWith("\r\n") ? 2 : (str.charAt(0) == '\r' || str.charAt(0) == '\n' ? 1 : 0);
            int end = str.endsWith("\r\n") ? str.length() - 2 : (str.charAt(str.length() - 1) == '\r' || str.charAt(str.length() - 1) == '\n' ? str.length() - 1 : str.length());
            return str.substring(start, end);
        }
    }
}

