/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EEncryptionFailureBehavior;
import net.savignano.cryptography.enums.EEncryptionTypePriority;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.key.smime.SmimePublicKey;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.mail.encrypt.PgpMailEncryptor;
import net.savignano.cryptography.mail.encrypt.SmimeMailEncryptor;
import net.savignano.cryptography.mail.protect.IMailHeaderProtector;
import net.savignano.cryptography.mail.protect.LegacyMailHeaderProtector;
import net.savignano.cryptography.mail.protect.Rfc822MailHeaderProtector;
import net.savignano.cryptography.mail.sign.PgpMailSigner;
import net.savignano.cryptography.mail.sign.SmimeMailSigner;
import net.savignano.cryptography.mail.visitor.RegexVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.common.user.VirtualUser;
import net.savignano.snotify.atlassian.mailer.AMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpEncryptionKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpSignKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeEncryptionKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimePublicKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeSignKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAtlassianMailer<T extends IUser<?>>
extends AMailer {
    private static final Logger log = LoggerFactory.getLogger(AAtlassianMailer.class);
    private final ISnotifyAppProperties appProps;
    private final ISnotifyUserProperties userProps;
    private final ISnotifyProjectProperties projectProps;
    private boolean cachedEncryptionDesired;
    private MimeMessage lastCheckedMessage;
    private Pattern skipEncryptionPattern;
    private Boolean signingEnabled;
    private Boolean protectionEnabled;
    private Boolean projectSpecificEncryption;
    private Boolean defaultProjectEncryption;
    private Boolean ambiguousProjectEncryption;
    private Boolean noProjectEncryption;
    private final Map<Address, T> address2UserMap = new HashMap<Address, T>();
    private SmimeMailEncryptor smimeEncryptor;
    private SmimeMailSigner smimeSigner;
    private PgpMailEncryptor pgpEncryptor;
    private PgpMailSigner pgpSigner;

    public AAtlassianMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties projectProps) {
        super(session);
        this.appProps = appProps;
        this.userProps = userProps;
        this.projectProps = projectProps;
        if (appProps == null) {
            throw new IllegalArgumentException("Application Properties must not be null.");
        }
        if (userProps == null) {
            throw new IllegalArgumentException("User Properties must not be null.");
        }
        if (projectProps == null) {
            throw new IllegalArgumentException("Project Properties must not be null.");
        }
        appProps.setString(EProperty.MAILER_VERSION, this.getVersion());
    }

    protected abstract List<T> getUsers(Address var1);

    protected abstract boolean hasValidKey(T var1, ECryptographyType var2);

    @Override
    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        if (!super.isEncryptionDesired(msgAndAddress)) {
            return false;
        }
        if (this.lastCheckedMessage == msgAndAddress.message) {
            return this.cachedEncryptionDesired;
        }
        this.lastCheckedMessage = msgAndAddress.message;
        this.cachedEncryptionDesired = this.isEncryptionDesiredBySkipRegex(this.lastCheckedMessage) && this.isEncryptionDesiredByProject(this.lastCheckedMessage);
        return this.cachedEncryptionDesired;
    }

    private boolean isEncryptionDesiredBySkipRegex(MimeMessage msg) {
        if (this.getSkipEncryptionPattern() == null) {
            return true;
        }
        log.debug("Checking whether email should be encrypted with pattern: {}", (Object)this.getSkipEncryptionPattern().pattern());
        RegexVisitor visitor = new RegexVisitor(this.getSkipEncryptionPattern());
        visitor.setCheckHeaders(true);
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            log.error("Error checking if message with ID " + MessageUtil.getMessageId(msg) + " should be encrypted. Error message: " + e.getMessage());
        }
        if (((List)visitor.getResult()).isEmpty()) {
            log.debug("No match found in email.");
            return true;
        }
        log.info("Email will not get encrypted, because of regex matching.");
        return false;
    }

    private boolean isEncryptionDesiredByProject(MimeMessage msg) {
        if (!this.isProjectSpecificEncryption()) {
            return true;
        }
        List<String> projectKeys = this.extractProjectKeys(msg);
        log.debug("Checking encryption state for project(s): {}", projectKeys);
        switch (projectKeys.size()) {
            case 0: {
                return this.isNoProjectEncryption();
            }
            case 1: {
                String projectKey = projectKeys.get(0);
                return this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, this.isDefaultProjectEncryption(), projectKey);
            }
        }
        String projectKey = projectKeys.get(0);
        boolean encryptionDesired = this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, this.isDefaultProjectEncryption(), projectKey);
        for (int i = 1; i < projectKeys.size(); ++i) {
            projectKey = projectKeys.get(i);
            if (encryptionDesired == this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, this.isDefaultProjectEncryption(), projectKey)) continue;
            log.debug("Projects have different encryption settings.");
            encryptionDesired = this.isAmbiguousProjectEncryption();
            break;
        }
        return encryptionDesired;
    }

    @Override
    protected boolean isSigningDesired(MessageAndAddress msgAndAddress) {
        if (!super.isSigningDesired(msgAndAddress)) {
            return false;
        }
        return this.isSigningEnabled();
    }

    @Override
    protected EKeyValidity encrypt(MimeMessage msg, Address from, Address to, ECryptographyType cryptography) throws IOException, MessagingException {
        EKeyValidity validity;
        String msgId = MessageUtil.getMessageId(msg);
        log.debug("Encrypting message: {}", (Object)msgId);
        switch (cryptography) {
            case NONE: {
                validity = EKeyValidity.VALID;
                break;
            }
            case PGP: {
                validity = this.encryptPgp(msg, from, to);
                break;
            }
            case SMIME: {
                validity = this.encryptSmime(msg, from, to);
                break;
            }
            default: {
                log.error("Unknonw cryptography desired: {}", (Object)cryptography);
                validity = EKeyValidity.ERROR;
            }
        }
        if (validity != EKeyValidity.VALID) {
            log.warn("Could not encrypt message \"{}\", key validity was: {}", (Object)msgId, (Object)validity);
        }
        return validity;
    }

    private EKeyValidity encryptSmime(MimeMessage msg, Address from, Address to) throws IOException, MessagingException {
        Address domainAddress;
        SmimePublicKey key = this.getSmimeEncryptionKey(to);
        if (!key.isValid() && (domainAddress = this.getMatchingDomainAddress(to)) != null) {
            key = this.getSmimeEncryptionKey(domainAddress);
        }
        if (key.isValid()) {
            SmimeMailEncryptor encryptor = this.getSmimeMailEncryptor();
            encryptor.setSenderPublicKey(this.getSmimeEncryptionSenderKey(from));
            encryptor.encryptMessage(msg, key);
        }
        return key.getKeyValidity();
    }

    private Address getMatchingDomainAddress(Address to) {
        String domain;
        String tweakDomainCert = this.getAppProps().getString(EProperty.TWEAK_SMIME_DOMAIN_CERTIFICATE);
        if (tweakDomainCert == null) {
            return null;
        }
        String toEmail = MessageUtil.getEmail(to);
        try {
            domain = toEmail.substring(toEmail.indexOf(64));
        }
        catch (IndexOutOfBoundsException e) {
            log.warn("Malformed email encountered. Could not determine domain. Address: {}", (Object)to);
            return null;
        }
        for (String email : tweakDomainCert.split(" ")) {
            if (!email.endsWith(domain)) continue;
            try {
                return new InternetAddress(email);
            }
            catch (AddressException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private SmimeMailEncryptor getSmimeMailEncryptor() {
        if (this.smimeEncryptor == null) {
            this.smimeEncryptor = this.loadSmimeEncryptor();
        }
        return this.smimeEncryptor;
    }

    private SmimeMailEncryptor loadSmimeEncryptor() {
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(this.getSession());
        encryptor.setProductInfo(this.getProductInformation());
        return encryptor;
    }

    protected SmimePublicKey getSmimeEncryptionKey(Address to) {
        IUser<?> user = this.virtualUser(to);
        SmimePublicKeyManager manager = new SmimePublicKeyManager(this.getAppProps(), this.getUserProps());
        return (SmimePublicKey)manager.getKey(user);
    }

    protected SmimePublicKey getSmimeEncryptionSenderKey(Address from) {
        String email = MessageUtil.getEmail(from);
        SmimeEncryptionKeyManager manager = new SmimeEncryptionKeyManager(this.getAppProps());
        return (SmimePublicKey)manager.getKey(email);
    }

    private EKeyValidity encryptPgp(MimeMessage msg, Address from, Address to) throws IOException, MessagingException {
        PgpPublicKey key = this.getPgpEncryptionKey(to);
        PgpPublicKey senderKey = this.getPgpEncryptionSenderKey(from);
        if (key.isValid()) {
            PgpMailEncryptor encryptor = this.getPgpMailEncryptor();
            encryptor.setSenderPublicKey(senderKey);
            encryptor.encryptMessage(msg, key);
        }
        return key.getKeyValidity();
    }

    private PgpMailEncryptor getPgpMailEncryptor() {
        if (this.pgpEncryptor == null) {
            this.pgpEncryptor = this.loadPgpEncryptor();
        }
        return this.pgpEncryptor;
    }

    private PgpMailEncryptor loadPgpEncryptor() {
        PgpMailEncryptor encryptor = new PgpMailEncryptor(this.getSession());
        encryptor.setProductInfo(this.getProductInformation());
        Long tweakAlgorithm = this.getAppProps().getLong(EProperty.TWEAK_PGP_SYMMETRIC_KEY_ALGORITHM);
        if (tweakAlgorithm != null) {
            encryptor.setForceSymmetricKeyAlgorithm(tweakAlgorithm.intValue());
        }
        return encryptor;
    }

    protected PgpPublicKey getPgpEncryptionKey(Address to) {
        IUser<?> user = this.virtualUser(to);
        PgpPublicKeyManager manager = new PgpPublicKeyManager(this.getAppProps(), this.getUserProps());
        return (PgpPublicKey)manager.getKey(user);
    }

    protected PgpPublicKey getPgpEncryptionSenderKey(Address from) {
        String email = MessageUtil.getEmail(from);
        PgpEncryptionKeyManager manager = new PgpEncryptionKeyManager(this.getAppProps());
        return (PgpPublicKey)manager.getKey(email);
    }

    @Override
    protected EKeyValidity sign(MimeMessage msg, Address from, ECryptographyType cryptography) throws IOException, MessagingException {
        EKeyValidity validity;
        String msgId = MessageUtil.getMessageId(msg);
        log.debug("Signing message: {}", (Object)msgId);
        switch (cryptography) {
            case NONE: {
                validity = EKeyValidity.VALID;
                break;
            }
            case PGP: {
                validity = this.signPgp(msg, from);
                break;
            }
            case SMIME: {
                validity = this.signSmime(msg, from);
                break;
            }
            default: {
                log.error("Unknonw cryptography desired: {}", (Object)cryptography);
                validity = EKeyValidity.ERROR;
            }
        }
        if (validity != EKeyValidity.VALID) {
            log.warn("Could not sign message \"{}\", key validity was: {}", (Object)msgId, (Object)validity);
        }
        return validity;
    }

    private EKeyValidity signSmime(MimeMessage msg, Address from) throws IOException, MessagingException {
        SmimeSignKey key = this.getSmimeSignKey(from);
        if (key.isValid()) {
            SmimeMailSigner signer = this.getSmimeMailSigner();
            signer.signMessage(msg, key);
        }
        return key.getKeyValidity();
    }

    private SmimeMailSigner getSmimeMailSigner() {
        if (this.smimeSigner == null) {
            this.smimeSigner = this.loadSmimeSigner();
        }
        return this.smimeSigner;
    }

    private SmimeMailSigner loadSmimeSigner() {
        SmimeMailSigner signer = new SmimeMailSigner(this.getSession());
        signer.setProductInfo(this.getProductInformation());
        signer.setOpaque(this.getAppProps().getBoolean(EProperty.SIGNING_SMIME_OPAQUE));
        return signer;
    }

    protected SmimeSignKey getSmimeSignKey(Address from) {
        String email = MessageUtil.getEmail(from);
        SmimeSignKeyManager manager = new SmimeSignKeyManager(this.getAppProps());
        return (SmimeSignKey)manager.getKey(email);
    }

    private EKeyValidity signPgp(MimeMessage msg, Address from) throws IOException, MessagingException {
        PgpSignKey key = this.getPgpSignKey(from);
        if (key.isValid()) {
            PgpMailSigner signer = this.getPgpMailSigner();
            signer.signMessage(msg, key);
        }
        return key.getKeyValidity();
    }

    private PgpMailSigner getPgpMailSigner() {
        if (this.pgpSigner == null) {
            this.pgpSigner = this.loadPgpSigner();
        }
        return this.pgpSigner;
    }

    private PgpMailSigner loadPgpSigner() {
        PgpMailSigner signer = new PgpMailSigner(this.getSession());
        signer.setProductInfo(this.getProductInformation());
        return signer;
    }

    protected PgpSignKey getPgpSignKey(Address from) {
        String email = MessageUtil.getEmail(from);
        PgpSignKeyManager manager = new PgpSignKeyManager(this.getAppProps());
        return (PgpSignKey)manager.getKey(email);
    }

    @Override
    protected boolean isProtectionDesired(MessageAndAddress msgAndAddress) {
        if (!super.isProtectionDesired(msgAndAddress)) {
            return false;
        }
        return this.isProtectionEnabled();
    }

    @Override
    protected EKeyValidity protect(MimeMessage msg, ECryptographyType cryptography) throws IOException, MessagingException {
        IMailHeaderProtector protector;
        String protectionType = this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_METHOD);
        log.debug("Type of mail header protector to get for {}: {}", (Object)cryptography, (Object)protectionType);
        if (cryptography == null || protectionType == null) {
            log.warn("No cryptography or protection method given. Cannot protect headers.");
            return EKeyValidity.ERROR;
        }
        switch (protectionType) {
            case "protected-headers-v1": {
                protector = new LegacyMailHeaderProtector();
                break;
            }
            case "message/rfc822": {
                protector = new Rfc822MailHeaderProtector();
                break;
            }
            default: {
                log.warn("Unknown subject protection method specified. Email headers will not be protected. Valid methods: \"protected-headers-v1\", \"message/rfc822\"");
                protector = null;
            }
        }
        if (protector != null) {
            protector.protectHeaders(msg);
            return EKeyValidity.VALID;
        }
        return EKeyValidity.ERROR;
    }

    protected abstract List<String> extractProjectKeys(MimeMessage var1);

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }

    public ISnotifyProjectProperties getProjectProps() {
        return this.projectProps;
    }

    protected IUser<?> virtualUser(Address address) {
        Object user = this.getUser(address);
        if (user == null) {
            user = new VirtualUser((InternetAddress)address);
        }
        return user;
    }

    public T getUser(Address address) {
        if (address == null) {
            return null;
        }
        IUser user = (IUser)this.address2UserMap.get(address);
        if (user == null && !this.address2UserMap.containsKey(address)) {
            user = this.loadUser(address);
            this.address2UserMap.put(address, user);
        }
        return (T)user;
    }

    protected T loadUser(Address address) {
        IUser user;
        List<T> users = this.getUsers(address);
        switch (users.size()) {
            case 0: {
                user = null;
                break;
            }
            case 1: {
                user = (IUser)users.get(0);
                break;
            }
            default: {
                log.warn("Multiple users found for email \"{}\". This might lead to unpredictable behavior of the email encryption process. Found users: {}", (Object)address, users);
                user = this.selectBestUser(users);
            }
        }
        log.info("Used user for email \"{}\": {}", (Object)address, (Object)user);
        return (T)user;
    }

    private T selectBestUser(Collection<T> users) {
        Object user;
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                user = this.getValidKeyUser(users, ECryptographyType.SMIME);
                break;
            }
            case SMIME_PREFERED: {
                user = this.getValidKeyUser(users, ECryptographyType.SMIME);
                if (user != null) break;
                user = this.getValidKeyUser(users, ECryptographyType.PGP);
                break;
            }
            case PGP_ONLY: {
                user = this.getValidKeyUser(users, ECryptographyType.PGP);
                break;
            }
            case PGP_PREFERED: {
                user = this.getValidKeyUser(users, ECryptographyType.PGP);
                if (user != null) break;
                user = this.getValidKeyUser(users, ECryptographyType.SMIME);
                break;
            }
            default: {
                log.error("Unhandled type priority: {}", (Object)this.getTypePriority());
                user = (IUser)users.iterator().next();
            }
        }
        return user;
    }

    private T getValidKeyUser(Collection<T> users, ECryptographyType cryptography) {
        for (IUser user : users) {
            if (!this.hasValidKey(user, cryptography)) continue;
            return (T)user;
        }
        return null;
    }

    public Pattern getSkipEncryptionPattern() {
        if (this.skipEncryptionPattern == null) {
            this.skipEncryptionPattern = this.loadSkipEncryptionPattern();
        }
        return this.skipEncryptionPattern;
    }

    protected Pattern loadSkipEncryptionPattern() {
        String skipEncRegex = this.getAppProps().getString(EProperty.TWEAK_SKIP_ENCRYPTION_REGEX);
        if (skipEncRegex != null) {
            try {
                return Pattern.compile(skipEncRegex, 8);
            }
            catch (PatternSyntaxException e) {
                log.error("Regex pattern \"" + skipEncRegex + "\" for skipping email encryption is not a valid regex. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean isProjectSpecificEncryption() {
        if (this.projectSpecificEncryption == null) {
            this.projectSpecificEncryption = this.loadProjectSpecificEncryption();
        }
        return this.projectSpecificEncryption;
    }

    protected boolean loadProjectSpecificEncryption() {
        return this.getAppProps().getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION);
    }

    public boolean isDefaultProjectEncryption() {
        if (this.defaultProjectEncryption == null) {
            this.defaultProjectEncryption = this.loadDefaultProjectEncryption();
        }
        return this.defaultProjectEncryption;
    }

    protected boolean loadDefaultProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isAmbiguousProjectEncryption() {
        if (this.ambiguousProjectEncryption == null) {
            this.ambiguousProjectEncryption = this.loadAmbiguousProjectEncryption();
        }
        return this.ambiguousProjectEncryption;
    }

    protected boolean loadAmbiguousProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isNoProjectEncryption() {
        if (this.noProjectEncryption == null) {
            this.noProjectEncryption = this.loadNoProjectEncryption();
        }
        return this.noProjectEncryption;
    }

    protected boolean loadNoProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.NO_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isSigningEnabled() {
        if (this.signingEnabled == null) {
            this.signingEnabled = this.loadSigningEnabled();
        }
        return this.signingEnabled;
    }

    protected boolean loadSigningEnabled() {
        return this.getAppProps().getBoolean(EProperty.SIGNING_ENABLED);
    }

    public boolean isProtectionEnabled() {
        if (this.protectionEnabled == null) {
            this.protectionEnabled = this.loadProtectionEnabled();
        }
        return this.protectionEnabled;
    }

    protected boolean loadProtectionEnabled() {
        return this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION);
    }

    @Override
    protected boolean loadAdditionalSigningPgp() {
        return this.getAppProps().getBoolean(EProperty.TWEAK_PGP_ADDITIONAL_SIGN);
    }

    @Override
    protected boolean loadAdditionalSigningSmime() {
        return this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_ADDITIONAL_SIGN);
    }

    @Override
    protected boolean loadDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    @Override
    protected boolean loadFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    @Override
    protected boolean loadLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    @Override
    protected boolean loadDryRun() {
        return this.getAppProps().getBoolean(EProperty.TWEAK_DRY_RUN_MAILER);
    }

    @Override
    protected EEncryptionFailureBehavior loadFailureBehavior() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_FAILURE_BEHAVIOR, EEncryptionFailureBehavior.class);
    }

    @Override
    protected EEncryptionTypePriority loadTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    @Override
    protected String getSubjectReplacement(MimeMessage msg) {
        String replacement = null;
        if (this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION)) {
            String method = this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_METHOD);
            replacement = this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_REPLACEMENT);
            if (replacement == null && method != null) {
                switch (method) {
                    case "protected-headers-v1": {
                        replacement = "...";
                        break;
                    }
                    case "message/rfc822": {
                        replacement = "(hidden)";
                        break;
                    }
                    default: {
                        log.warn("Unknown subject protection method specified. Email subject will not be protected. Valid methods: \"protected-headers-v1\", \"message/rfc822\"");
                    }
                }
            }
        }
        return replacement;
    }
}

