/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.pgp.PgpSignKeyStoreLoader;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.APrivateKeyManager;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpSignKeyManager
extends APrivateKeyManager<PgpSignKey, String> {
    private static final Logger log = LoggerFactory.getLogger(PgpSignKeyManager.class);

    public PgpSignKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpSignKey, String>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpSignKey, String>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpSignKey, String>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        return loaders;
    }

    private Optional<IKeyLoader<PgpSignKey, String>> createKeyStoreLoader() {
        PGPSecretKeyRingCollection keyRings;
        ISnotifyAppProperties appProps = this.getAppProps();
        String location = appProps.getString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No PGP key store configured to retrieve PGP private keys from.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_PGP_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_PGP_KEY_PASSWORD)) {
            log.error("Error retrieving password for PGP private key.");
            return Optional.empty();
        }
        log.debug("PGP key store configured: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            keyRings = PgpUtil.loadSecretKeys(in);
        }
        catch (Exception e) {
            log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new PgpSignKeyStoreLoader(keyRings, keyPassword));
    }

    @Override
    protected PgpSignKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new PgpSignKey(validity, keySource);
    }

    @Override
    protected Class<PgpSignKey> getCacheClass() {
        return PgpSignKey.class;
    }
}

