/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openssl;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.ECPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.DSAParameter;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.cert.X509AttributeCertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CRLHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMEncryptedKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMException;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMKeyPairParser;
import net.savignano.thirdparty.org.bouncycastle.openssl.X509TrustedCertificateBlock;
import net.savignano.thirdparty.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import net.savignano.thirdparty.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;
import net.savignano.thirdparty.org.bouncycastle.util.io.pem.PemHeader;
import net.savignano.thirdparty.org.bouncycastle.util.io.pem.PemObject;
import net.savignano.thirdparty.org.bouncycastle.util.io.pem.PemObjectParser;
import net.savignano.thirdparty.org.bouncycastle.util.io.pem.PemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEMParser
extends PemReader {
    public static final String TYPE_CERTIFICATE_REQUEST = "CERTIFICATE REQUEST";
    public static final String TYPE_NEW_CERTIFICATE_REQUEST = "NEW CERTIFICATE REQUEST";
    public static final String TYPE_CERTIFICATE = "CERTIFICATE";
    public static final String TYPE_TRUSTED_CERTIFICATE = "TRUSTED CERTIFICATE";
    public static final String TYPE_X509_CERTIFICATE = "X509 CERTIFICATE";
    public static final String TYPE_X509_CRL = "X509 CRL";
    public static final String TYPE_PKCS7 = "PKCS7";
    public static final String TYPE_CMS = "CMS";
    public static final String TYPE_ATTRIBUTE_CERTIFICATE = "ATTRIBUTE CERTIFICATE";
    public static final String TYPE_EC_PARAMETERS = "EC PARAMETERS";
    public static final String TYPE_PUBLIC_KEY = "PUBLIC KEY";
    public static final String TYPE_RSA_PUBLIC_KEY = "RSA PUBLIC KEY";
    public static final String TYPE_RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
    public static final String TYPE_DSA_PRIVATE_KEY = "DSA PRIVATE KEY";
    public static final String TYPE_EC_PRIVATE_KEY = "EC PRIVATE KEY";
    public static final String TYPE_ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
    public static final String TYPE_PRIVATE_KEY = "PRIVATE KEY";
    protected final Map parsers = new HashMap();

    public PEMParser(Reader reader) {
        super(reader);
        this.parsers.put(TYPE_CERTIFICATE_REQUEST, new PKCS10CertificationRequestParser());
        this.parsers.put(TYPE_NEW_CERTIFICATE_REQUEST, new PKCS10CertificationRequestParser());
        this.parsers.put(TYPE_CERTIFICATE, new X509CertificateParser());
        this.parsers.put(TYPE_TRUSTED_CERTIFICATE, new X509TrustedCertificateParser());
        this.parsers.put(TYPE_X509_CERTIFICATE, new X509CertificateParser());
        this.parsers.put(TYPE_X509_CRL, new X509CRLParser());
        this.parsers.put(TYPE_PKCS7, new PKCS7Parser());
        this.parsers.put(TYPE_CMS, new PKCS7Parser());
        this.parsers.put(TYPE_ATTRIBUTE_CERTIFICATE, new X509AttributeCertificateParser());
        this.parsers.put(TYPE_EC_PARAMETERS, new ECCurveParamsParser());
        this.parsers.put(TYPE_PUBLIC_KEY, new PublicKeyParser());
        this.parsers.put(TYPE_RSA_PUBLIC_KEY, new RSAPublicKeyParser());
        this.parsers.put(TYPE_RSA_PRIVATE_KEY, new KeyPairParser(new RSAKeyPairParser()));
        this.parsers.put(TYPE_DSA_PRIVATE_KEY, new KeyPairParser(new DSAKeyPairParser()));
        this.parsers.put(TYPE_EC_PRIVATE_KEY, new KeyPairParser(new ECDSAKeyPairParser()));
        this.parsers.put(TYPE_ENCRYPTED_PRIVATE_KEY, new EncryptedPrivateKeyParser());
        this.parsers.put(TYPE_PRIVATE_KEY, new PrivateKeyParser());
    }

    public Object readObject() throws IOException {
        PemObject obj = this.readPemObject();
        if (obj != null) {
            String type = obj.getType();
            Object pemObjectParser = this.parsers.get(type);
            if (pemObjectParser != null) {
                return ((PemObjectParser)pemObjectParser).parseObject(obj);
            }
            throw new IOException("unrecognised object: " + type);
        }
        return null;
    }

    public Set<String> getSupportedTypes() {
        return Collections.unmodifiableSet(this.parsers.keySet());
    }

    private static class PrivateKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return PrivateKeyInfo.getInstance(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing PRIVATE KEY: " + e.toString(), e);
            }
        }
    }

    private static class EncryptedPrivateKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(obj.getContent()));
            }
            catch (Exception e) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + e.toString(), e);
            }
        }
    }

    private static class ECCurveParamsParser
    implements PemObjectParser {
        private ECCurveParamsParser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1Primitive param = ASN1Primitive.fromByteArray(obj.getContent());
                if (param instanceof ASN1ObjectIdentifier) {
                    return ASN1Primitive.fromByteArray(obj.getContent());
                }
                if (param instanceof ASN1Sequence) {
                    return X9ECParameters.getInstance(param);
                }
                return null;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("exception extracting EC named curve: " + e.toString());
            }
        }
    }

    private static class X509AttributeCertificateParser
    implements PemObjectParser {
        private X509AttributeCertificateParser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            return new X509AttributeCertificateHolder(obj.getContent());
        }
    }

    private static class PKCS7Parser
    implements PemObjectParser {
        private PKCS7Parser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1InputStream aIn = new ASN1InputStream(obj.getContent());
                return ContentInfo.getInstance(aIn.readObject());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing PKCS7 object: " + e.toString(), e);
            }
        }
    }

    private static class PKCS10CertificationRequestParser
    implements PemObjectParser {
        private PKCS10CertificationRequestParser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS10CertificationRequest(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing certrequest: " + e.toString(), e);
            }
        }
    }

    private static class X509CRLParser
    implements PemObjectParser {
        private X509CRLParser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509CRLHolder(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing cert: " + e.toString(), e);
            }
        }
    }

    private static class X509TrustedCertificateParser
    implements PemObjectParser {
        private X509TrustedCertificateParser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509TrustedCertificateBlock(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing cert: " + e.toString(), e);
            }
        }
    }

    private static class X509CertificateParser
    implements PemObjectParser {
        private X509CertificateParser() {
        }

        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509CertificateHolder(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing cert: " + e.toString(), e);
            }
        }
    }

    private static class RSAPublicKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject obj) throws IOException {
            try {
                RSAPublicKey rsaPubStructure = RSAPublicKey.getInstance(obj.getContent());
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), rsaPubStructure);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem extracting key: " + e.toString(), e);
            }
        }
    }

    private static class PublicKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject obj) throws IOException {
            return SubjectPublicKeyInfo.getInstance(obj.getContent());
        }
    }

    private static class RSAKeyPairParser
    implements PEMKeyPairParser {
        private RSAKeyPairParser() {
        }

        public PEMKeyPair parse(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey keyStruct = RSAPrivateKey.getInstance(seq);
                RSAPublicKey pubSpec = new RSAPublicKey(keyStruct.getModulus(), keyStruct.getPublicExponent());
                AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
                return new PEMKeyPair(new SubjectPublicKeyInfo(algId, pubSpec), new PrivateKeyInfo(algId, keyStruct));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating RSA private key: " + e.toString(), e);
            }
        }
    }

    private static class ECDSAKeyPairParser
    implements PEMKeyPairParser {
        private ECDSAKeyPairParser() {
        }

        public PEMKeyPair parse(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                ECPrivateKey pKey = ECPrivateKey.getInstance(seq);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, pKey.getParametersObject());
                PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, pKey);
                if (pKey.getPublicKey() != null) {
                    SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
                    return new PEMKeyPair(pubInfo, privInfo);
                }
                return new PEMKeyPair(null, privInfo);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating EC private key: " + e.toString(), e);
            }
        }
    }

    private static class DSAKeyPairParser
    implements PEMKeyPairParser {
        private DSAKeyPairParser() {
        }

        public PEMKeyPair parse(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                ASN1Integer p = ASN1Integer.getInstance(seq.getObjectAt(1));
                ASN1Integer q = ASN1Integer.getInstance(seq.getObjectAt(2));
                ASN1Integer g = ASN1Integer.getInstance(seq.getObjectAt(3));
                ASN1Integer y = ASN1Integer.getInstance(seq.getObjectAt(4));
                ASN1Integer x = ASN1Integer.getInstance(seq.getObjectAt(5));
                return new PEMKeyPair(new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(p.getValue(), q.getValue(), g.getValue())), y), new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(p.getValue(), q.getValue(), g.getValue())), x));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating DSA private key: " + e.toString(), e);
            }
        }
    }

    private static class KeyPairParser
    implements PemObjectParser {
        private final PEMKeyPairParser pemKeyPairParser;

        public KeyPairParser(PEMKeyPairParser pemKeyPairParser) {
            this.pemKeyPairParser = pemKeyPairParser;
        }

        public Object parseObject(PemObject obj) throws IOException {
            boolean isEncrypted = false;
            String dekInfo = null;
            List headers = obj.getHeaders();
            for (PemHeader hdr : headers) {
                if (hdr.getName().equals("Proc-Type") && hdr.getValue().equals("4,ENCRYPTED")) {
                    isEncrypted = true;
                    continue;
                }
                if (!hdr.getName().equals("DEK-Info")) continue;
                dekInfo = hdr.getValue();
            }
            byte[] keyBytes = obj.getContent();
            try {
                if (isEncrypted) {
                    StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
                    String dekAlgName = tknz.nextToken();
                    byte[] iv = Hex.decode(tknz.nextToken());
                    return new PEMEncryptedKeyPair(dekAlgName, iv, keyBytes, this.pemKeyPairParser);
                }
                return this.pemKeyPairParser.parse(keyBytes);
            }
            catch (IOException e) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e);
                }
                throw new PEMException(e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e);
                }
                throw new PEMException(e.getMessage(), e);
            }
        }
    }
}

