/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.asn1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class KyberPublicKey
extends ASN1Object {
    private byte[] t;
    private byte[] rho;

    public KyberPublicKey(byte[] t, byte[] rho) {
        this.t = t;
        this.rho = rho;
    }

    public KyberPublicKey(ASN1Sequence seq) {
        this.t = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
        this.rho = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
    }

    public byte[] getT() {
        return Arrays.clone(this.t);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.t));
        v.add(new DEROctetString(this.rho));
        return new DERSequence(v);
    }

    public static KyberPublicKey getInstance(Object o) {
        if (o instanceof KyberPublicKey) {
            return (KyberPublicKey)o;
        }
        if (o != null) {
            return new KyberPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

