/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime;

import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.Utils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class SNTRUPrimeKEMExtractor
implements EncapsulatedSecretExtractor {
    private final SNTRUPrimePrivateKeyParameters privateKey;

    public SNTRUPrimeKEMExtractor(SNTRUPrimePrivateKeyParameters privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] extractSecret(byte[] encapsulation) {
        SNTRUPrimeParameters params = this.privateKey.getParameters();
        int p = params.getP();
        int q = params.getQ();
        int w = params.getW();
        int roundedPolynomialBytes = params.getRoundedPolynomialBytes();
        byte[] f = new byte[p];
        Utils.getDecodedSmallPolynomial(f, this.privateKey.getF(), p);
        byte[] ginv = new byte[p];
        Utils.getDecodedSmallPolynomial(ginv, this.privateKey.getGinv(), p);
        short[] c = new short[p];
        Utils.getRoundedDecodedPolynomial(c, encapsulation, p, q);
        short[] cf = new short[p];
        Utils.multiplicationInRQ(cf, c, f, p, q);
        short[] cf3 = new short[p];
        Utils.scalarMultiplicationInRQ(cf3, cf, 3, q);
        byte[] e = new byte[p];
        Utils.transformRQToR3(e, cf3);
        byte[] ev = new byte[p];
        Utils.multiplicationInR3(ev, e, ginv, p);
        byte[] r = new byte[p];
        Utils.checkForSmallPolynomial(r, ev, p, w);
        byte[] encR = new byte[(p + 3) / 4];
        Utils.getEncodedSmallPolynomial(encR, r, p);
        short[] h = new short[p];
        Utils.getDecodedPolynomial(h, this.privateKey.getPk(), p, q);
        short[] hr = new short[p];
        Utils.multiplicationInRQ(hr, h, r, p, q);
        short[] cnew = new short[p];
        Utils.roundPolynomial(cnew, hr);
        byte[] C = new byte[roundedPolynomialBytes];
        Utils.getRoundedEncodedPolynomial(C, cnew, p, q);
        byte[] innerHCPrefix = new byte[]{3};
        byte[] innerHCHash = Utils.getHashWithPrefix(innerHCPrefix, encR);
        byte[] hcInput = new byte[innerHCHash.length / 2 + this.privateKey.getHash().length];
        System.arraycopy(innerHCHash, 0, hcInput, 0, innerHCHash.length / 2);
        System.arraycopy(this.privateKey.getHash(), 0, hcInput, innerHCHash.length / 2, this.privateKey.getHash().length);
        byte[] hcPrefix = new byte[]{2};
        byte[] hc = Utils.getHashWithPrefix(hcPrefix, hcInput);
        byte[] ct = new byte[C.length + hc.length / 2];
        System.arraycopy(C, 0, ct, 0, C.length);
        System.arraycopy(hc, 0, ct, C.length, hc.length / 2);
        int mask = Arrays.areEqual(encapsulation, ct) ? 0 : -1;
        Utils.updateDiffMask(encR, this.privateKey.getRho(), mask);
        byte[] innerSSPrefix = new byte[]{3};
        byte[] innerSSHash = Utils.getHashWithPrefix(innerSSPrefix, encR);
        byte[] ssInput = new byte[innerSSHash.length / 2 + ct.length];
        System.arraycopy(innerSSHash, 0, ssInput, 0, innerSSHash.length / 2);
        System.arraycopy(ct, 0, ssInput, innerSSHash.length / 2, ct.length);
        byte[] ssPrefix = new byte[]{(byte)(mask + 1)};
        byte[] ssHash = Utils.getHashWithPrefix(ssPrefix, ssInput);
        return Arrays.copyOfRange(ssHash, 0, params.getSessionKeySize() / 8);
    }

    public int getEncapsulationLength() {
        return this.privateKey.getParameters().getRoundedPolynomialBytes() + 32;
    }
}

