/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru;

import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.Polynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.parameters.NTRUHPSParameterSet;

public class HPSPolynomial
extends Polynomial {
    public HPSPolynomial(NTRUHPSParameterSet params) {
        super(params);
    }

    public byte[] sqToBytes(int len) {
        int j;
        int i;
        byte[] r = new byte[len];
        short[] t = new short[8];
        for (i = 0; i < this.params.packDegree() / 8; ++i) {
            for (j = 0; j < 8; ++j) {
                t[j] = (short)HPSPolynomial.modQ(this.coeffs[8 * i + j] & 0xFFFF, this.params.q());
            }
            r[11 * i + 0] = (byte)(t[0] & 0xFF);
            r[11 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 0x1F) << 3);
            r[11 * i + 2] = (byte)(t[1] >>> 5 | (t[2] & 3) << 6);
            r[11 * i + 3] = (byte)(t[2] >>> 2 & 0xFF);
            r[11 * i + 4] = (byte)(t[2] >>> 10 | (t[3] & 0x7F) << 1);
            r[11 * i + 5] = (byte)(t[3] >>> 7 | (t[4] & 0xF) << 4);
            r[11 * i + 6] = (byte)(t[4] >>> 4 | (t[5] & 1) << 7);
            r[11 * i + 7] = (byte)(t[5] >>> 1 & 0xFF);
            r[11 * i + 8] = (byte)(t[5] >>> 9 | (t[6] & 0x3F) << 2);
            r[11 * i + 9] = (byte)(t[6] >>> 6 | (t[7] & 7) << 5);
            r[11 * i + 10] = (byte)(t[7] >>> 3);
        }
        for (j = 0; j < this.params.packDegree() - 8 * i; ++j) {
            t[j] = (short)HPSPolynomial.modQ(this.coeffs[8 * i + j] & 0xFFFF, this.params.q());
        }
        while (j < 8) {
            t[j] = 0;
            ++j;
        }
        switch (this.params.packDegree() & 7) {
            case 4: {
                r[11 * i + 0] = (byte)(t[0] & 0xFF);
                r[11 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 0x1F) << 3);
                r[11 * i + 2] = (byte)(t[1] >>> 5 | (t[2] & 3) << 6);
                r[11 * i + 3] = (byte)(t[2] >>> 2 & 0xFF);
                r[11 * i + 4] = (byte)(t[2] >>> 10 | (t[3] & 0x7F) << 1);
                r[11 * i + 5] = (byte)(t[3] >>> 7 | (t[4] & 0xF) << 4);
                break;
            }
            case 2: {
                r[11 * i + 0] = (byte)(t[0] & 0xFF);
                r[11 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 0x1F) << 3);
                r[11 * i + 2] = (byte)(t[1] >>> 5 | (t[2] & 3) << 6);
            }
        }
        return r;
    }

    public void sqFromBytes(byte[] a) {
        int i;
        int n = this.coeffs.length;
        for (i = 0; i < this.params.packDegree() / 8; ++i) {
            this.coeffs[8 * i + 0] = (short)((a[11 * i + 0] & 0xFF) >>> 0 | ((short)(a[11 * i + 1] & 0xFF) & 7) << 8);
            this.coeffs[8 * i + 1] = (short)((a[11 * i + 1] & 0xFF) >>> 3 | ((short)(a[11 * i + 2] & 0xFF) & 0x3F) << 5);
            this.coeffs[8 * i + 2] = (short)((a[11 * i + 2] & 0xFF) >>> 6 | ((short)(a[11 * i + 3] & 0xFF) & 0xFF) << 2 | ((short)(a[11 * i + 4] & 0xFF) & 1) << 10);
            this.coeffs[8 * i + 3] = (short)((a[11 * i + 4] & 0xFF) >>> 1 | ((short)(a[11 * i + 5] & 0xFF) & 0xF) << 7);
            this.coeffs[8 * i + 4] = (short)((a[11 * i + 5] & 0xFF) >>> 4 | ((short)(a[11 * i + 6] & 0xFF) & 0x7F) << 4);
            this.coeffs[8 * i + 5] = (short)((a[11 * i + 6] & 0xFF) >>> 7 | ((short)(a[11 * i + 7] & 0xFF) & 0xFF) << 1 | ((short)(a[11 * i + 8] & 0xFF) & 3) << 9);
            this.coeffs[8 * i + 6] = (short)((a[11 * i + 8] & 0xFF) >>> 2 | ((short)(a[11 * i + 9] & 0xFF) & 0x1F) << 6);
            this.coeffs[8 * i + 7] = (short)((a[11 * i + 9] & 0xFF) >>> 5 | ((short)(a[11 * i + 10] & 0xFF) & 0xFF) << 3);
        }
        switch (this.params.packDegree() & 7) {
            case 4: {
                this.coeffs[8 * i + 0] = (short)((a[11 * i + 0] & 0xFF) >>> 0 | ((short)(a[11 * i + 1] & 0xFF) & 7) << 8);
                this.coeffs[8 * i + 1] = (short)((a[11 * i + 1] & 0xFF) >>> 3 | ((short)(a[11 * i + 2] & 0xFF) & 0x3F) << 5);
                this.coeffs[8 * i + 2] = (short)((a[11 * i + 2] & 0xFF) >>> 6 | ((short)(a[11 * i + 3] & 0xFF) & 0xFF) << 2 | ((short)(a[11 * i + 4] & 0xFF) & 1) << 10);
                this.coeffs[8 * i + 3] = (short)((a[11 * i + 4] & 0xFF) >>> 1 | ((short)(a[11 * i + 5] & 0xFF) & 0xF) << 7);
                break;
            }
            case 2: {
                this.coeffs[8 * i + 0] = (short)((a[11 * i + 0] & 0xFF) >>> 0 | ((short)(a[11 * i + 1] & 0xFF) & 7) << 8);
                this.coeffs[8 * i + 1] = (short)((a[11 * i + 1] & 0xFF) >>> 3 | ((short)(a[11 * i + 2] & 0xFF) & 0x3F) << 5);
            }
        }
        this.coeffs[n - 1] = 0;
    }

    public void lift(Polynomial a) {
        int n = this.coeffs.length;
        System.arraycopy(a.coeffs, 0, this.coeffs, 0, n);
        this.z3ToZq();
    }

    public void r2Inv(Polynomial a) {
        HPSPolynomial f = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial g = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial v = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial w = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        this.r2Inv(a, f, g, v, w);
    }

    public void rqInv(Polynomial a) {
        HPSPolynomial ai2 = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial b = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial c = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial s = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        this.rqInv(a, ai2, b, c, s);
    }

    public void s3Inv(Polynomial a) {
        HPSPolynomial f = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial g = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial v = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        HPSPolynomial w = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        this.s3Inv(a, f, g, v, w);
    }
}

